/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.simulator.simulators.nrm;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jamesii.ml3.model.agents.AgentField;
import org.jamesii.ml3.model.agents.IAgent;
import org.jamesii.ml3.model.agents.rules.Rule;
import org.jamesii.ml3.simulator.simulators.nrm.DependencyManagingAgent;
import org.jamesii.ml3.simulator.simulators.nrm.DependencyManagingInstance;
import org.jamesii.ml3.simulator.simulators.nrm.TypeDependencyMap;

public class ForEachInstanceSet {
    private Set<DependencyManagingInstance> instances;
    private DependencyManagingAgent agent;
    private Rule rule;
    private Set<DependencyManagingAgent> aliveDependencies;
    private Set<AgentField> fieldDependencies;
    private Set<String> typeDependencies;
    private TypeDependencyMap tdm;

    public ForEachInstanceSet(Rule rule, DependencyManagingAgent agent, TypeDependencyMap tdm) {
        this.agent = agent;
        this.rule = rule;
        this.tdm = tdm;
        this.fieldDependencies = new HashSet<AgentField>();
        this.typeDependencies = new HashSet<String>();
        this.aliveDependencies = new HashSet<DependencyManagingAgent>();
        this.instances = new HashSet<DependencyManagingInstance>();
    }

    public Set<DependencyManagingInstance> getInstances() {
        return this.instances;
    }

    public void setInstances(Set<DependencyManagingInstance> instances) {
        this.instances = instances;
    }

    public void addInstance(DependencyManagingInstance instance) {
        this.instances.add(instance);
    }

    public void clearInstances() {
        this.instances.clear();
    }

    private void addAliveDependency(DependencyManagingAgent agent) {
        this.aliveDependencies.add(agent);
    }

    private void clearAliveDependencies() {
        this.aliveDependencies.clear();
    }

    private void addFieldDependency(AgentField field) {
        this.fieldDependencies.add(field);
    }

    private void clearFieldDependencies() {
        this.fieldDependencies.clear();
    }

    private void addTypeDependency(String type) {
        this.typeDependencies.add(type);
    }

    private void clearTypeDependencies() {
        this.typeDependencies.clear();
    }

    public void removeDependenciesToThis() {
        for (DependencyManagingAgent agent : this.aliveDependencies) {
            agent.removeAliveDependentInstanceSet(this);
        }
        for (AgentField field : this.fieldDependencies) {
            String fieldName = field.getField();
            DependencyManagingAgent agent = (DependencyManagingAgent)field.getAgent();
            agent.removeDependentInstanceSet(fieldName, this);
        }
        for (String type : this.typeDependencies) {
            this.tdm.removeTypeDependentInstanceSet(type, this);
        }
        this.clearAliveDependencies();
        this.clearFieldDependencies();
        this.clearTypeDependencies();
    }

    public void addDependenciesToThis(Collection<AgentField> fields, Collection<IAgent> agents, Collection<String> types) {
        for (AgentField field : fields) {
            String fieldName = field.getField();
            DependencyManagingAgent agent = (DependencyManagingAgent)field.getAgent();
            agent.addDependentInstanceSet(fieldName, this);
            this.addFieldDependency(field);
        }
        for (IAgent agent : agents) {
            DependencyManagingAgent dmAgent = (DependencyManagingAgent)agent;
            dmAgent.addAliveDependentInstanceSet(this);
            this.addAliveDependency(dmAgent);
        }
        for (String type : types) {
            this.tdm.addTypeDependentInstanceSet(type, this);
            this.addTypeDependency(type);
        }
    }

    public IAgent getAgent() {
        return this.agent;
    }

    public Rule getRule() {
        return this.rule;
    }

    public String toString() {
        return this.agent.getType() + ":" + this.agent.getID() + ":" + this.rule.toString();
    }
}

