/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.simulator.simulators.nrm;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jamesii.ml3.model.agents.AgentField;
import org.jamesii.ml3.model.agents.IAgent;
import org.jamesii.ml3.model.agents.rules.Rule;
import org.jamesii.ml3.simulator.simulators.RuleInstance;
import org.jamesii.ml3.simulator.simulators.nrm.DependencyManagingAgent;
import org.jamesii.ml3.simulator.simulators.nrm.TypeDependencyMap;

public class DependencyManagingInstance
extends RuleInstance {
    private Set<DependencyManagingAgent> aliveDependencies;
    private Set<AgentField> fieldDependencies;
    private Set<String> typeDependencies;
    private TypeDependencyMap tdm;

    public DependencyManagingInstance(Rule rule, DependencyManagingAgent agent, TypeDependencyMap tdm) {
        super(rule, agent);
        this.tdm = tdm;
        this.aliveDependencies = new HashSet<DependencyManagingAgent>();
        this.fieldDependencies = new HashSet<AgentField>();
        this.typeDependencies = new HashSet<String>();
    }

    private void addAliveDependency(DependencyManagingAgent agent) {
        this.aliveDependencies.add(agent);
    }

    private void clearAliveDependencies() {
        this.aliveDependencies.clear();
    }

    private void addFieldDependency(AgentField field) {
        this.fieldDependencies.add(field);
    }

    private void clearFieldDependencies() {
        this.fieldDependencies.clear();
    }

    private void addTypeDependency(String type) {
        this.typeDependencies.add(type);
    }

    private void clearTypeDependencies() {
        this.typeDependencies.clear();
    }

    public void removeDependenciesToThis() {
        for (DependencyManagingAgent agent : this.aliveDependencies) {
            agent.removeAliveDependency(this);
        }
        for (AgentField field : this.fieldDependencies) {
            String fieldName = field.getField();
            DependencyManagingAgent agent = (DependencyManagingAgent)field.getAgent();
            agent.removeDependency(fieldName, this);
        }
        for (String type : this.typeDependencies) {
            this.tdm.removeTypeDependency(type, this);
        }
        this.clearAliveDependencies();
        this.clearFieldDependencies();
        this.clearTypeDependencies();
    }

    public void addDependenciesToThis(Collection<AgentField> fields, Collection<IAgent> agents, Collection<String> types) {
        for (AgentField field : fields) {
            String fieldName = field.getField();
            DependencyManagingAgent agent = (DependencyManagingAgent)field.getAgent();
            agent.addDependency(fieldName, this);
            this.addFieldDependency(field);
        }
        for (IAgent agent : agents) {
            DependencyManagingAgent dmAgent = (DependencyManagingAgent)agent;
            dmAgent.addAliveDependency(this);
            this.addAliveDependency(dmAgent);
        }
        for (String type : types) {
            this.tdm.addTypeDependency(type, this);
            this.addTypeDependency(type);
        }
    }

    public void addFieldDependenciesToThis(AgentField ... fields) {
        for (AgentField field : fields) {
            String fieldName = field.getField();
            DependencyManagingAgent agent = (DependencyManagingAgent)field.getAgent();
            agent.addDependency(fieldName, this);
            this.addFieldDependency(field);
        }
    }

    public void addAliveDependenciesToThis(IAgent ... agents) {
        for (IAgent agent : agents) {
            DependencyManagingAgent dmAgent = (DependencyManagingAgent)agent;
            dmAgent.addAliveDependency(this);
            this.addAliveDependency(dmAgent);
        }
    }

    public void addTypeDependenciesToThis(String ... types) {
        for (String type : types) {
            this.tdm.addTypeDependency(type, this);
            this.addTypeDependency(type);
        }
    }

    public String toString() {
        return "[" + this.getRule() + ", " + this.getAgent().getType() + ":" + this.getAgent().getID() + "]";
    }
}

