/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.simulator.simulators.nrm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jamesii.ml3.model.agents.IAgent;
import org.jamesii.ml3.model.agents.SimpleAgent;
import org.jamesii.ml3.model.values.IValue;
import org.jamesii.ml3.simulator.simulators.nrm.DependencyManagingInstance;
import org.jamesii.ml3.simulator.simulators.nrm.ForEachInstanceSet;

public class DependencyManagingAgent
extends SimpleAgent
implements IAgent {
    private Map<String, Set<DependencyManagingInstance>> fieldDependencies = new HashMap<String, Set<DependencyManagingInstance>>();
    private Set<DependencyManagingInstance> aliveDependencies;
    private Map<String, Set<ForEachInstanceSet>> fieldDependentInstanceSets;
    private Set<ForEachInstanceSet> aliveDependentInstanceSets;

    public DependencyManagingAgent(int id, String agentType, double timeOfBirth, double timeOfDeath, Map<String, IValue> attributes, Map<String, Set<IAgent>> links) {
        super(id, agentType, timeOfBirth, timeOfDeath, attributes, links);
        for (String attribute : attributes.keySet()) {
            this.fieldDependencies.put(attribute, new HashSet());
        }
        for (String link : links.keySet()) {
            this.fieldDependencies.put(link, new HashSet());
        }
        this.aliveDependencies = new HashSet<DependencyManagingInstance>();
        this.fieldDependentInstanceSets = new HashMap<String, Set<ForEachInstanceSet>>();
        for (String attribute : attributes.keySet()) {
            this.fieldDependentInstanceSets.put(attribute, new HashSet());
        }
        for (String link : links.keySet()) {
            this.fieldDependentInstanceSets.put(link, new HashSet());
        }
        this.aliveDependentInstanceSets = new HashSet<ForEachInstanceSet>();
    }

    public void addDependency(String field, DependencyManagingInstance instance) {
        this.fieldDependencies.get(field).add(instance);
    }

    public void removeDependency(String field, DependencyManagingInstance instance) {
        this.fieldDependencies.get(field).remove(instance);
    }

    public void addAliveDependency(DependencyManagingInstance instance) {
        this.aliveDependencies.add(instance);
    }

    public void removeAliveDependency(DependencyManagingInstance instance) {
        this.aliveDependencies.remove(instance);
    }

    public Set<DependencyManagingInstance> getAliveDependencies() {
        return this.aliveDependencies;
    }

    public Set<DependencyManagingInstance> getDependencies(String field) {
        return this.fieldDependencies.get(field);
    }

    public void addDependentInstanceSet(String field, ForEachInstanceSet instance) {
        this.fieldDependentInstanceSets.get(field).add(instance);
    }

    public void removeDependentInstanceSet(String field, ForEachInstanceSet instance) {
        this.fieldDependentInstanceSets.get(field).remove(instance);
    }

    public void addAliveDependentInstanceSet(ForEachInstanceSet instance) {
        this.aliveDependentInstanceSets.add(instance);
    }

    public void removeAliveDependentInstanceSet(ForEachInstanceSet instance) {
        this.aliveDependentInstanceSets.remove(instance);
    }

    public Set<ForEachInstanceSet> getAliveDependentInstanceSets() {
        return this.aliveDependentInstanceSets;
    }

    public Set<ForEachInstanceSet> getDependentInstanceSets(String field) {
        return this.fieldDependentInstanceSets.get(field);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof IAgent)) {
            return false;
        }
        return this.getID() == ((IAgent)other).getID();
    }

    @Override
    public int hashCode() {
        return this.getID();
    }
}

