/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.simulator.simulators;

import java.util.HashMap;
import java.util.Map;
import org.jamesii.ml3.simulator.simulators.RuleInstance;

public class RuleActivation {
    private int ruleID;
    private int agentID;
    private Map<String, Object> variables;
    private double activationTime;

    public RuleActivation(int ruleID, int agentID, double activationTime) {
        this.activationTime = activationTime;
        this.ruleID = ruleID;
        this.agentID = agentID;
        this.variables = new HashMap<String, Object>();
    }

    public RuleActivation(RuleInstance instance, double activationTime) {
        this.activationTime = activationTime;
        this.ruleID = instance.getRule().getID();
        this.agentID = instance.getAgent().getID();
        this.variables = new HashMap<String, Object>();
        for (String key : instance.getWheres().keySet()) {
            this.variables.put(key, instance.getWheres().get(key));
        }
        for (String key : instance.getForEachs().keySet()) {
            this.variables.put(key, instance.getForEachs().get(key));
        }
    }

    public int getRuleID() {
        return this.ruleID;
    }

    public int getAgentID() {
        return this.agentID;
    }

    public double getActivationTime() {
        return this.activationTime;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }
}

