/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.parser.nodes.statements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jamesii.ml3.parser.AbstractParseTreeNode;
import org.jamesii.ml3.parser.IParseTreeNode;
import org.jamesii.ml3.parser.nodes.expressions.IExpression;
import org.jamesii.ml3.parser.nodes.statements.AssignmentLeftSideNode;
import org.jamesii.ml3.parser.nodes.statements.IStatement;
import org.jamesii.ml3.parser.nodes.statements.IStatementVisitor;

public class AssignmentStatement
extends AbstractParseTreeNode
implements IStatement {
    private Collection<AssignmentLeftSideNode> leftSides = new ArrayList<AssignmentLeftSideNode>();
    private IExpression rightSideExpression;

    public AssignmentStatement(IParseTreeNode parent) {
        super(parent);
    }

    public String toString() {
        String ret = String.join((CharSequence)" := ", this.leftSides.stream().map(e -> e.toString()).collect(Collectors.toList()));
        return ret + " := " + this.rightSideExpression;
    }

    @Override
    public <R, P> R accept(IStatementVisitor<R, P> v, P p) {
        return v.visit(this, p);
    }

    public IExpression getRightSideExpression() {
        return this.rightSideExpression;
    }

    public void setRightSideExpression(IExpression rightSideExpression) {
        this.rightSideExpression = rightSideExpression;
    }

    public Collection<AssignmentLeftSideNode> getLeftSides() {
        return this.leftSides;
    }

    public void setLeftSides(Collection<AssignmentLeftSideNode> leftSides) {
        this.leftSides = leftSides;
    }

    public void addLeftSide(AssignmentLeftSideNode leftSide) {
        this.leftSides.add(leftSide);
    }
}

