/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.parser.nodes.statements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jamesii.ml3.parser.AbstractParseTreeNode;
import org.jamesii.ml3.parser.IParseTreeNode;
import org.jamesii.ml3.parser.nodes.expressions.IExpression;
import org.jamesii.ml3.parser.nodes.statements.AssignmentLeftSideNode;
import org.jamesii.ml3.parser.nodes.statements.IStatement;
import org.jamesii.ml3.parser.nodes.statements.IStatementVisitor;

public class AgentCreationStatement
extends AbstractParseTreeNode
implements IStatement {
    private Collection<AssignmentLeftSideNode> leftSides;
    private Collection<String> variables = new ArrayList<String>();
    private String agentType;
    private Map<String, IExpression> initializations;

    public AgentCreationStatement(IParseTreeNode parent) {
        super(parent);
        this.leftSides = new ArrayList<AssignmentLeftSideNode>();
        this.initializations = new HashMap<String, IExpression>();
    }

    public String toString() {
        String lefts = String.join((CharSequence)" := ", this.leftSides.stream().map(e -> e.toString()).collect(Collectors.toList()));
        String vars = String.join((CharSequence)" := ", this.leftSides.stream().map(e -> e.toString()).collect(Collectors.toList()));
        lefts = lefts.isEmpty() ? "" : lefts + " := ";
        vars = vars.isEmpty() ? "" : vars + " := ";
        String ret = String.join((CharSequence)", ", this.initializations.keySet().stream().map(e -> e + " := " + this.initializations.get(e)).collect(Collectors.toList()));
        return lefts + vars + "new " + this.agentType + "(" + ret + ")";
    }

    @Override
    public <R, P> R accept(IStatementVisitor<R, P> v, P p) {
        return v.visit(this, p);
    }

    public String getAgentType() {
        return this.agentType;
    }

    public void setAgentType(String agentType) {
        this.agentType = agentType;
    }

    public Map<String, IExpression> getInitializations() {
        return this.initializations;
    }

    public void setInitializations(Map<String, IExpression> attributeInitializations) {
        this.initializations = attributeInitializations;
    }

    public Collection<AssignmentLeftSideNode> getLeftSides() {
        return this.leftSides;
    }

    public void setLeftSides(List<AssignmentLeftSideNode> leftSides) {
        this.leftSides = leftSides;
    }

    public void addLeftSide(AssignmentLeftSideNode leftSide) {
        this.leftSides.add(leftSide);
    }

    public Collection<String> getVariables() {
        return this.variables;
    }

    public void setVariables(Collection<String> variables) {
        this.variables = variables;
    }

    public void addVariable(String variable) {
        this.variables.add(variable);
    }
}

