/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.parser.nodes.expressions;

import org.jamesii.ml3.parser.AbstractParseTreeNode;
import org.jamesii.ml3.parser.IParseTreeNode;
import org.jamesii.ml3.parser.nodes.expressions.IExpression;
import org.jamesii.ml3.parser.nodes.expressions.IExpressionVisitor;

public class RelationalExpression
extends AbstractParseTreeNode
implements IExpression {
    private RelationalOperator operator;
    private IExpression leftExpression;
    private IExpression rightExpression;

    public RelationalExpression(IParseTreeNode parent, RelationalOperator operator) {
        super(parent);
        this.operator = operator;
    }

    public String toString() {
        return "(" + this.leftExpression + " " + (Object)((Object)this.operator) + " " + this.rightExpression + ")";
    }

    @Override
    public <R, P> R accept(IExpressionVisitor<R, P> v, P p) {
        return v.visit(this, p);
    }

    public IExpression getLeftExpression() {
        return this.leftExpression;
    }

    public void setLeftExpression(IExpression leftExpression) {
        this.leftExpression = leftExpression;
    }

    public IExpression getRightExpression() {
        return this.rightExpression;
    }

    public void setRightExpression(IExpression rightExpression) {
        this.rightExpression = rightExpression;
    }

    public RelationalOperator getOperator() {
        return this.operator;
    }

    public void setOperator(RelationalOperator operator) {
        this.operator = operator;
    }

    public static enum RelationalOperator {
        G{

            public String toString() {
                return ">";
            }
        }
        ,
        GEQ{

            public String toString() {
                return ">=";
            }
        }
        ,
        LEQ{

            public String toString() {
                return "<=";
            }
        }
        ,
        L{

            public String toString() {
                return "<";
            }
        };

    }
}

