/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.parser.nodes.expressions;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jamesii.ml3.parser.AbstractParseTreeNode;
import org.jamesii.ml3.parser.IParseTreeNode;
import org.jamesii.ml3.parser.nodes.expressions.IExpression;
import org.jamesii.ml3.parser.nodes.expressions.IExpressionVisitor;

public class FunctionCallExpression
extends AbstractParseTreeNode
implements IExpression {
    private IExpression baseExpression;
    private String functionName;
    private List<IExpression> parameters;

    public FunctionCallExpression(IParseTreeNode parent, String functionIdentifier) {
        super(parent);
        this.functionName = functionIdentifier;
        this.parameters = new ArrayList<IExpression>();
    }

    public String toString() {
        String params = String.join((CharSequence)", ", this.parameters.stream().map(e -> e.toString()).collect(Collectors.toList()));
        return (this.baseExpression != null ? this.baseExpression + "." : "") + this.functionName + "(" + params + ")";
    }

    @Override
    public <R, P> R accept(IExpressionVisitor<R, P> v, P p) {
        return v.visit(this, p);
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public List<IExpression> getParameters() {
        return this.parameters;
    }

    public void addParameter(IExpression parameter) {
        this.parameters.add(parameter);
    }

    public void setParameters(List<IExpression> parameters) {
        this.parameters = parameters;
    }

    public IExpression getBaseExpression() {
        return this.baseExpression;
    }

    public void setBaseExpression(IExpression baseExpression) {
        this.baseExpression = baseExpression;
    }
}

