/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.parser.nodes;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jamesii.ml3.parser.AbstractParseTreeNode;
import org.jamesii.ml3.parser.nodes.ModelNode;
import org.jamesii.ml3.parser.nodes.ParameterDeclarationNode;
import org.jamesii.ml3.parser.nodes.WhereClauseNode;
import org.jamesii.ml3.parser.nodes.statements.IStatement;

public class ProcedureDeclarationNode
extends AbstractParseTreeNode {
    private String agentType;
    private String procedureName;
    private List<ParameterDeclarationNode> parameters;
    private IStatement statement;
    private WhereClauseNode whereClause;

    public ProcedureDeclarationNode(ModelNode modelNode, String agentType, String procedureName) {
        super(modelNode);
        this.agentType = agentType;
        this.procedureName = procedureName;
        this.parameters = new ArrayList<ParameterDeclarationNode>();
    }

    public String toString() {
        String params = String.join((CharSequence)", ", this.parameters.stream().map(e -> e.toString()).collect(Collectors.toList()));
        String where = this.whereClause != null ? "\n" + this.whereClause : "";
        return this.agentType + "." + this.procedureName + "(" + params + ") -> " + this.statement + where + ";\n\n";
    }

    public String getAgentType() {
        return this.agentType;
    }

    public void setAgentType(String agentType) {
        this.agentType = agentType;
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public void setProcedureName(String procedureName) {
        this.procedureName = procedureName;
    }

    public IStatement getStatement() {
        return this.statement;
    }

    public void setStatement(IStatement statement) {
        this.statement = statement;
    }

    public WhereClauseNode getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(WhereClauseNode whereClause) {
        this.whereClause = whereClause;
    }

    public List<ParameterDeclarationNode> getParameters() {
        return this.parameters;
    }

    public void addParameter(ParameterDeclarationNode parameter) {
        this.parameters.add(parameter);
    }

    public void setParameters(List<ParameterDeclarationNode> parameters) {
        this.parameters = parameters;
    }
}

