/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.parser.maps;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.jamesii.ml3.model.maps.ContinuousValueMap;
import org.jamesii.ml3.model.maps.IValueMap;
import org.jamesii.ml3.model.maps.SimpleValueMap;
import org.jamesii.ml3.model.types.BasicType;
import org.jamesii.ml3.model.types.IType;
import org.jamesii.ml3.model.values.IValue;
import org.jamesii.ml3.parser.ParserUtil;
import org.jamesii.ml3.parser.maps.MapBuilderException;

public class MapBuilder {
    private Iterable<CSVRecord> csv;
    private boolean withHeader;
    private String path;

    public MapBuilder(String path, boolean withHeader) throws IOException {
        this.withHeader = withHeader;
        this.path = path;
        CSVFormat format = CSVFormat.DEFAULT.withIgnoreSurroundingSpaces();
        if (withHeader) {
            format = format.withHeader(new String[0]);
        }
        FileReader in = new FileReader(path);
        this.csv = format.parse((Reader)in).getRecords();
    }

    public IValueMap buildMap(int indexColumn, int valueColumn) {
        ArrayList<IValue> indices = new ArrayList<IValue>();
        ArrayList<IValue> values = new ArrayList<IValue>();
        for (CSVRecord record : this.csv) {
            IValue index = ParserUtil.parseConstantCode(record.get(indexColumn));
            IValue value = ParserUtil.parseConstantCode(record.get(valueColumn));
            indices.add(index);
            values.add(value);
        }
        return this.buildMapFromLists("" + indexColumn, "" + valueColumn, indices, values);
    }

    public IValueMap buildMap(String indexColumn, String valueColumn) {
        if (!this.withHeader) {
            throw new MapBuilderException("Tried to acces a headlerless map by header.");
        }
        ArrayList<IValue> indices = new ArrayList<IValue>();
        ArrayList<IValue> values = new ArrayList<IValue>();
        for (CSVRecord record : this.csv) {
            IValue index = ParserUtil.parseConstantCode(record.get(indexColumn));
            IValue value = ParserUtil.parseConstantCode(record.get(valueColumn));
            indices.add(index);
            values.add(value);
        }
        return this.buildMapFromLists(indexColumn, valueColumn, indices, values);
    }

    public IValueMap buildMap(int indexColumn, String valueColumn) {
        if (!this.withHeader) {
            throw new MapBuilderException("Tried to acces a headlerless map by header.");
        }
        ArrayList<IValue> indices = new ArrayList<IValue>();
        ArrayList<IValue> values = new ArrayList<IValue>();
        for (CSVRecord record : this.csv) {
            IValue index = ParserUtil.parseConstantCode(record.get(indexColumn));
            IValue value = ParserUtil.parseConstantCode(record.get(valueColumn));
            indices.add(index);
            values.add(value);
        }
        return this.buildMapFromLists("" + indexColumn, valueColumn, indices, values);
    }

    public IValueMap buildMap(String indexColumn, int valueColumn) {
        if (!this.withHeader) {
            throw new MapBuilderException("Tried to acces a headlerless map by header.");
        }
        ArrayList<IValue> indices = new ArrayList<IValue>();
        ArrayList<IValue> values = new ArrayList<IValue>();
        for (CSVRecord record : this.csv) {
            IValue index = ParserUtil.parseConstantCode(record.get(indexColumn));
            IValue value = ParserUtil.parseConstantCode(record.get(valueColumn));
            indices.add(index);
            values.add(value);
        }
        return this.buildMapFromLists(indexColumn, "" + valueColumn, indices, values);
    }

    private IValueMap buildMapFromLists(String indexColumn, String valueColumn, List<IValue> indices, List<IValue> values) {
        if (indices.size() < 1) {
            throw new MapBuilderException("Map " + this.path + "(" + indexColumn + ", " + valueColumn + ") has length 0.");
        }
        if (this.isNumericalIndex(indices, indexColumn)) {
            return this.createContinuousValueMap(indices, values);
        }
        return this.createSimpleValueMap(indices, values);
    }

    private SimpleValueMap createSimpleValueMap(List<IValue> indices, List<IValue> values) {
        SimpleValueMap map = new SimpleValueMap();
        for (int i = 0; i < indices.size(); ++i) {
            map.put(indices.get(i), values.get(i));
        }
        return map;
    }

    private ContinuousValueMap createContinuousValueMap(List<IValue> indices, List<IValue> values) {
        ContinuousValueMap map = new ContinuousValueMap(values.get(0));
        for (int i = 0; i < indices.size(); ++i) {
            map.put(indices.get(i), values.get(i));
        }
        return map;
    }

    private boolean isNumericalIndex(List<IValue> indices, String indexColumn) {
        IType firstType = indices.get(0).getType();
        boolean numerical = firstType.equals(BasicType.INT) || firstType.equals(BasicType.REAL);
        for (IValue index : indices) {
            IType type = index.getType();
            if (numerical && (type.equals(BasicType.INT) || type.equals(BasicType.REAL)) || type.equals(firstType)) continue;
            throw new MapBuilderException("Map " + this.path + " with index " + indexColumn + " has incompatible index values.");
        }
        return numerical;
    }
}

