/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.jamesii.ml3.parser.ILanguageErrorListener;

public class PrintoutLanguageErrorListener
implements ILanguageErrorListener {
    private PrintStream out;

    public PrintoutLanguageErrorListener() {
        this.out = System.out;
    }

    public PrintoutLanguageErrorListener(PrintStream out) {
        this.out = out;
    }

    public PrintoutLanguageErrorListener(File target) throws FileNotFoundException {
        this.out = new PrintStream(new FileOutputStream(target), true);
    }

    public PrintoutLanguageErrorListener(String target) throws IOException {
        File file = new File(target);
        file.createNewFile();
        this.out = new PrintStream(new FileOutputStream(file), true);
    }

    @Override
    public void onSyntaxError(String fileName, int line, int charPosInLine, String offendingSymbol, String message) {
        this.out.println(fileName + "[" + line + ":" + charPosInLine + "]['" + offendingSymbol + "']: " + message);
    }
}

