/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.parser;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.jamesii.ml3.model.types.AgentType;
import org.jamesii.ml3.model.types.BasicType;
import org.jamesii.ml3.model.types.Cardinality;
import org.jamesii.ml3.model.types.EnumType;
import org.jamesii.ml3.model.types.IType;
import org.jamesii.ml3.model.types.SetType;
import org.jamesii.ml3.model.values.BoolValue;
import org.jamesii.ml3.model.values.IValue;
import org.jamesii.ml3.model.values.IntValue;
import org.jamesii.ml3.model.values.RealValue;
import org.jamesii.ml3.model.values.StringValue;
import org.jamesii.ml3.parser.IParseTreeNode;
import org.jamesii.ml3.parser.antlr4.ML3Parser;
import org.jamesii.ml3.parser.antlr4.ML3Visitor;
import org.jamesii.ml3.parser.nodes.AgeRateNode;
import org.jamesii.ml3.parser.nodes.AgentDeclarationNode;
import org.jamesii.ml3.parser.nodes.AttributeDeclarationNode;
import org.jamesii.ml3.parser.nodes.EveryRateNode;
import org.jamesii.ml3.parser.nodes.EverySynchronizedRateNode;
import org.jamesii.ml3.parser.nodes.ForEachNode;
import org.jamesii.ml3.parser.nodes.FunctionDeclarationNode;
import org.jamesii.ml3.parser.nodes.GuardNode;
import org.jamesii.ml3.parser.nodes.IRateNode;
import org.jamesii.ml3.parser.nodes.InstantlyNode;
import org.jamesii.ml3.parser.nodes.LinkDeclarationNode;
import org.jamesii.ml3.parser.nodes.ModelNode;
import org.jamesii.ml3.parser.nodes.ParameterDeclarationNode;
import org.jamesii.ml3.parser.nodes.ProcedureDeclarationNode;
import org.jamesii.ml3.parser.nodes.RateExpressionNode;
import org.jamesii.ml3.parser.nodes.RuleDeclarationsNode;
import org.jamesii.ml3.parser.nodes.RuleNode;
import org.jamesii.ml3.parser.nodes.WhereClauseNode;
import org.jamesii.ml3.parser.nodes.expressions.AddExpression;
import org.jamesii.ml3.parser.nodes.expressions.AllAgentsExpression;
import org.jamesii.ml3.parser.nodes.expressions.AlterExpression;
import org.jamesii.ml3.parser.nodes.expressions.AndExpression;
import org.jamesii.ml3.parser.nodes.expressions.AttributeAccessExpression;
import org.jamesii.ml3.parser.nodes.expressions.ConditionalExpression;
import org.jamesii.ml3.parser.nodes.expressions.ConstExpression;
import org.jamesii.ml3.parser.nodes.expressions.DivideExpression;
import org.jamesii.ml3.parser.nodes.expressions.EgoExpression;
import org.jamesii.ml3.parser.nodes.expressions.EqualExpression;
import org.jamesii.ml3.parser.nodes.expressions.ExponentialExpression;
import org.jamesii.ml3.parser.nodes.expressions.FunctionCallExpression;
import org.jamesii.ml3.parser.nodes.expressions.IExpression;
import org.jamesii.ml3.parser.nodes.expressions.InExpression;
import org.jamesii.ml3.parser.nodes.expressions.MapConstantAccessExpression;
import org.jamesii.ml3.parser.nodes.expressions.ModuloExpression;
import org.jamesii.ml3.parser.nodes.expressions.MultiplyExpression;
import org.jamesii.ml3.parser.nodes.expressions.NowExpression;
import org.jamesii.ml3.parser.nodes.expressions.OrExpression;
import org.jamesii.ml3.parser.nodes.expressions.RelationalExpression;
import org.jamesii.ml3.parser.nodes.expressions.SetExpression;
import org.jamesii.ml3.parser.nodes.expressions.UnaryExpression;
import org.jamesii.ml3.parser.nodes.expressions.VariableAccessExpression;
import org.jamesii.ml3.parser.nodes.statements.AgentCreationStatement;
import org.jamesii.ml3.parser.nodes.statements.AssignmentLeftSideNode;
import org.jamesii.ml3.parser.nodes.statements.AssignmentStatement;
import org.jamesii.ml3.parser.nodes.statements.CompositionStatement;
import org.jamesii.ml3.parser.nodes.statements.ConditionalStatement;
import org.jamesii.ml3.parser.nodes.statements.ForEachStatement;
import org.jamesii.ml3.parser.nodes.statements.IStatement;
import org.jamesii.ml3.parser.nodes.statements.ProcedureCallStatement;

public class ParserANTLRVisitor
implements ML3Visitor<Object> {
    private Stack<IParseTreeNode> parseStack;
    private Set<String> constants = new HashSet<String>();
    private Set<String> maps = new HashSet<String>();

    public ParserANTLRVisitor() {
        this.parseStack = new Stack();
    }

    public Set<String> getConstantNames() {
        return this.constants;
    }

    public Set<String> getMapNames() {
        return this.maps;
    }

    public Stack<IParseTreeNode> getParseStack() {
        return this.parseStack;
    }

    public Object visit(ParseTree tree) {
        return tree.accept((ParseTreeVisitor)this);
    }

    @Override
    public IParseTreeNode visitAgentCreationArgument(@NotNull ML3Parser.AgentCreationArgumentContext ctx) {
        throw new RuntimeException("The method visitAgentCreationArgument(MoSiLLDEParser.AgentCreationArgumentContext) is not supported.");
    }

    @Override
    public AgentDeclarationNode visitAgentDec(ML3Parser.AgentDecContext ctx) {
        ModelNode parentNode = (ModelNode)this.parseStack.peek();
        String agentIdentifier = ctx.AgentIdentifier().getText();
        AgentDeclarationNode agentDeclarationNode = new AgentDeclarationNode(parentNode, agentIdentifier);
        this.parseStack.push(agentDeclarationNode);
        agentDeclarationNode.setAttributes(ctx.attrDec().stream().map(this::visitAttrDec).collect(Collectors.toList()));
        this.parseStack.pop();
        return agentDeclarationNode;
    }

    @Override
    public RuleNode visitRuleDec(ML3Parser.RuleDecContext ctx) {
        IParseTreeNode parentNode = this.parseStack.peek();
        RuleNode agentRuleNode = new RuleNode(parentNode);
        this.parseStack.push(agentRuleNode);
        if (ctx.where() != null) {
            agentRuleNode.setWhereClause(this.visitWhere(ctx.where()));
        }
        if (ctx.forEach() != null) {
            agentRuleNode.setForEachs(ctx.forEach().stream().map(this::visitForEach).collect(Collectors.toList()));
        }
        if (ctx.guard() != null) {
            agentRuleNode.setGuard(this.visitGuard(ctx.guard()));
        }
        if (ctx.rate() != null) {
            agentRuleNode.setRate(this.visitRate(ctx.rate()));
        }
        if (ctx.effect() != null) {
            agentRuleNode.setStatement(this.visitEffect(ctx.effect()));
        }
        this.parseStack.pop();
        return agentRuleNode;
    }

    @Override
    public IParseTreeNode visitAgeRate(@NotNull ML3Parser.AgeRateContext ctx) {
        throw new RuntimeException("The method visitAgeRate(MoSiLLDEParser.AgeRateContext) is not supported.");
    }

    @Override
    public AttributeDeclarationNode visitAttrDec(ML3Parser.AttrDecContext ctx) {
        AgentDeclarationNode parentNode = (AgentDeclarationNode)this.parseStack.peek();
        String attributeIdentifier = ctx.Identifier().getText();
        AttributeDeclarationNode attributeDeclarationNode = new AttributeDeclarationNode(parentNode, attributeIdentifier);
        this.parseStack.push(attributeDeclarationNode);
        attributeDeclarationNode.setType(this.visitBasicType(ctx.basicType()));
        if (ctx.constant() != null) {
            attributeDeclarationNode.setDefaultValue(this.visitConstant(ctx.constant()));
        }
        this.parseStack.pop();
        return attributeDeclarationNode;
    }

    @Override
    public IParseTreeNode visitCardinality(ML3Parser.CardinalityContext ctx) {
        throw new RuntimeException("The method visitCardinality(MoSiLLDEParser.CardinalityContext) is not supported.");
    }

    @Override
    public IParseTreeNode visitCardinalityClosedInterval(@NotNull ML3Parser.CardinalityClosedIntervalContext ctx) {
        throw new RuntimeException("The method visitCardinalityClosedInterval(MoSiLLDEParser.CardinalityClosedIntervalContext) is not supported.");
    }

    @Override
    public IParseTreeNode visitCardinalityExactInterval(@NotNull ML3Parser.CardinalityExactIntervalContext ctx) {
        throw new RuntimeException("The method visitCardinalityExactInterval(MoSiLLDEParser.CardinalityExactIntervalContext) is not supported.");
    }

    @Override
    public IParseTreeNode visitCardinalityOpenInterval(@NotNull ML3Parser.CardinalityOpenIntervalContext ctx) {
        throw new RuntimeException("The method visitCardinalityOpenInterval(MoSiLLDEParser.CardinalityOpenIntervalContext) is not supported.");
    }

    public IParseTreeNode visitChildren(org.antlr.v4.runtime.tree.RuleNode node) {
        return null;
    }

    @Override
    public IValue visitConstant(ML3Parser.ConstantContext ctx) {
        if (ctx.Nat() != null) {
            String text = ctx.getText();
            return new IntValue(Integer.valueOf(text));
        }
        if (ctx.Real() != null) {
            String text = ctx.getText();
            return new RealValue(Double.valueOf(text));
        }
        if (ctx.Bool() != null) {
            String text = ctx.Bool().getText();
            return new BoolValue(Boolean.valueOf(text));
        }
        String text = ctx.String().getText();
        return new StringValue(text.substring(1, text.length() - 1));
    }

    public IParseTreeNode visitErrorNode(ErrorNode node) {
        return null;
    }

    public IExpression visitExpression(ML3Parser.ExpressionContext ctx) {
        return (IExpression)ctx.accept(this);
    }

    @Override
    public ForEachNode visitForEach(ML3Parser.ForEachContext ctx) {
        ForEachNode fen = new ForEachNode((RuleNode)this.parseStack.peek());
        this.parseStack.push(fen);
        fen.setVariableName(ctx.LocalIdentifier().getText());
        fen.setExpression(this.visitExpression(ctx.expression()));
        this.parseStack.pop();
        return fen;
    }

    @Override
    public FunctionDeclarationNode visitFuncDec(ML3Parser.FuncDecContext ctx) {
        ModelNode parentNode = (ModelNode)this.parseStack.peek();
        String agentIdentifier = ctx.AgentIdentifier().getText();
        String functionIdentifier = ctx.Identifier().getText();
        FunctionDeclarationNode functionDeclarationNode = new FunctionDeclarationNode(parentNode, agentIdentifier, functionIdentifier);
        this.parseStack.push(functionDeclarationNode);
        functionDeclarationNode.setParameters(ctx.paramDec().stream().map(this::visitParamDec).collect(Collectors.toList()));
        if (ctx.where() != null) {
            functionDeclarationNode.setWhereClause(this.visitWhere(ctx.where()));
        }
        functionDeclarationNode.setExpression(this.visitExpression(ctx.expression()));
        this.parseStack.pop();
        return functionDeclarationNode;
    }

    @Override
    public GuardNode visitGuard(ML3Parser.GuardContext ctx) {
        GuardNode gn = new GuardNode((RuleNode)this.parseStack.peek());
        this.parseStack.push(gn);
        gn.setExpressions(ctx.expression().stream().map(this::visitExpression).collect(Collectors.toList()));
        this.parseStack.pop();
        return gn;
    }

    @Override
    public LinkDeclarationNode visitLinkDec(ML3Parser.LinkDecContext ctx) {
        String identifier_left = ctx.i_l.getText();
        String agentIdentifier_left = ctx.ai_l.getText();
        Cardinality cardinalityality_left = this.evalCardinality(ctx.c_l);
        Cardinality cardinalityality_right = this.evalCardinality(ctx.c_r);
        String agentIdentifier_right = ctx.ai_r.getText();
        String identifier_right = ctx.i_r.getText();
        return new LinkDeclarationNode((ModelNode)this.parseStack.peek(), identifier_left, agentIdentifier_left, cardinalityality_left, identifier_right, agentIdentifier_right, cardinalityality_right);
    }

    @Override
    public IExpression visitSetExpression(ML3Parser.SetExpressionContext ctx) {
        SetExpression sn = new SetExpression(this.parseStack.peek());
        this.parseStack.push(sn);
        sn.setExpressions(ctx.expression().stream().map(ectx -> this.visitExpression((ML3Parser.ExpressionContext)((Object)ectx))).collect(Collectors.toList()));
        this.parseStack.pop();
        return sn;
    }

    @Override
    public ModelNode visitModel(ML3Parser.ModelContext ctx) {
        ModelNode mn = new ModelNode();
        this.parseStack.push(mn);
        mn.setAgentDeclarations(ctx.agentDec().stream().map(this::visitAgentDec).collect(Collectors.toList()));
        mn.setLinkDeclarations(ctx.linkDec().stream().map(this::visitLinkDec).collect(Collectors.toList()));
        mn.setFunctionDeclarations(ctx.funcDec().stream().map(this::visitFuncDec).collect(Collectors.toList()));
        mn.setProcedureDeclarations(ctx.procDec().stream().map(this::visitProcDec).collect(Collectors.toList()));
        mn.setRuleDeclarations(ctx.ruleBlock().stream().map(this::visitRuleBlock).collect(Collectors.toList()));
        this.parseStack.pop();
        return mn;
    }

    @Override
    public ParameterDeclarationNode visitParamDec(ML3Parser.ParamDecContext ctx) {
        IParseTreeNode parentNode = this.parseStack.peek();
        String parameterIdentifier = ctx.LocalIdentifier().getText();
        ParameterDeclarationNode parameterDeclarationNode = new ParameterDeclarationNode(parentNode, parameterIdentifier);
        this.parseStack.push(parameterDeclarationNode);
        parameterDeclarationNode.setType(this.visitType(ctx.type()));
        this.parseStack.pop();
        return parameterDeclarationNode;
    }

    @Override
    public IRateNode visitRate(ML3Parser.RateContext ctx) {
        RuleNode parentNode = (RuleNode)this.parseStack.peek();
        if (ctx.Instantly() != null) {
            return new InstantlyNode(parentNode);
        }
        if (ctx.ageRate() != null) {
            AgeRateNode ageRateNode = new AgeRateNode(parentNode);
            this.parseStack.push(ageRateNode);
            ageRateNode.setAge(this.visitExpression(ctx.ageRate().expression()));
            this.parseStack.pop();
            return ageRateNode;
        }
        if (ctx.everyRate() != null) {
            return this.visitEveryRate(ctx.everyRate());
        }
        if (ctx.expression() != null) {
            RateExpressionNode rateExpressionNode = new RateExpressionNode(parentNode);
            this.parseStack.push(rateExpressionNode);
            rateExpressionNode.setExpression(this.visitExpression(ctx.expression()));
            this.parseStack.pop();
            return rateExpressionNode;
        }
        throw new RuntimeException("Could not evaluate Rate.");
    }

    @Override
    public RuleDeclarationsNode visitRuleBlock(ML3Parser.RuleBlockContext ctx) {
        ModelNode parentNode = (ModelNode)this.parseStack.peek();
        String agentIdentifier = ctx.AgentIdentifier().getText();
        RuleDeclarationsNode ruleDeclarationNode = new RuleDeclarationsNode(parentNode, agentIdentifier);
        this.parseStack.push(ruleDeclarationNode);
        ruleDeclarationNode.setRules(ctx.ruleDec().stream().map(this::visitRuleDec).collect(Collectors.toList()));
        this.parseStack.pop();
        return ruleDeclarationNode;
    }

    @Override
    public IStatement visitEffect(ML3Parser.EffectContext ctx) {
        IStatement stmt = this.visitStatement(ctx.statement());
        return stmt;
    }

    public IParseTreeNode visitTerminal(TerminalNode node) {
        return null;
    }

    @Override
    public WhereClauseNode visitWhere(ML3Parser.WhereContext ctx) {
        WhereClauseNode wcn = new WhereClauseNode(this.parseStack.peek());
        this.parseStack.push(wcn);
        for (int i = 0; i < ctx.LocalIdentifier().size(); ++i) {
            wcn.addVariable(ctx.LocalIdentifier(i).getText(), this.visitExpression(ctx.expression(i)));
        }
        this.parseStack.pop();
        return wcn;
    }

    @Override
    public ConstExpression visitConstantExpression(ML3Parser.ConstantExpressionContext ctx) {
        return new ConstExpression(this.parseStack.peek(), this.visitConstant(ctx.constant()));
    }

    @Override
    public IParseTreeNode visitVarAccessExpression(ML3Parser.VarAccessExpressionContext ctx) {
        if (ctx.Identifier() != null) {
            this.constants.add(ctx.Identifier().getText());
            return new VariableAccessExpression(this.parseStack.peek(), ctx.Identifier().getText());
        }
        return new VariableAccessExpression(this.parseStack.peek(), ctx.LocalIdentifier().getText());
    }

    @Override
    public IParseTreeNode visitMultiplyExpression(ML3Parser.MultiplyExpressionContext ctx) {
        if (ctx.Mul() != null) {
            MultiplyExpression me = new MultiplyExpression(this.parseStack.peek());
            this.parseStack.push(me);
            me.setLeftFactor(this.visitExpression(ctx.l));
            me.setRightFactor(this.visitExpression(ctx.r));
            this.parseStack.pop();
            return me;
        }
        if (ctx.Mod() != null) {
            ModuloExpression me = new ModuloExpression(this.parseStack.peek());
            this.parseStack.push(me);
            me.setDividend(this.visitExpression(ctx.l));
            me.setDivisor(this.visitExpression(ctx.r));
            this.parseStack.pop();
            return me;
        }
        if (ctx.Div() != null) {
            DivideExpression de = new DivideExpression(this.parseStack.peek());
            this.parseStack.push(de);
            de.setDividend(this.visitExpression(ctx.l));
            de.setDivisor(this.visitExpression(ctx.r));
            this.parseStack.pop();
            return de;
        }
        throw new RuntimeException("The impossible happened (ML3Parser sees '*' or '/' or '%' that is none of the three).");
    }

    @Override
    public IParseTreeNode visitAlterExpression(ML3Parser.AlterExpressionContext ctx) {
        return new AlterExpression(this.parseStack.peek());
    }

    @Override
    public IParseTreeNode visitFuncCallExpression(ML3Parser.FuncCallExpressionContext ctx) {
        FunctionCallExpression fce = new FunctionCallExpression(this.parseStack.peek(), ctx.Identifier().getText());
        this.parseStack.push(fce);
        fce.setBaseExpression(this.visitExpression(ctx.l));
        for (int i = 1; i < ctx.expression().size(); ++i) {
            fce.getParameters().add(this.visitExpression(ctx.expression(i)));
        }
        this.parseStack.pop();
        return fce;
    }

    @Override
    public IParseTreeNode visitParenExpression(ML3Parser.ParenExpressionContext ctx) {
        return this.visitExpression(ctx.e);
    }

    @Override
    public IParseTreeNode visitNowExpression(ML3Parser.NowExpressionContext ctx) {
        return new NowExpression(this.parseStack.peek());
    }

    @Override
    public IParseTreeNode visitAttrAccessExpression(ML3Parser.AttrAccessExpressionContext ctx) {
        AttributeAccessExpression aae = new AttributeAccessExpression(this.parseStack.peek());
        this.parseStack.push(aae);
        aae.setBaseExpression(this.visitExpression(ctx.l));
        aae.setAttributeName(ctx.id.getText());
        this.parseStack.pop();
        return aae;
    }

    @Override
    public EgoExpression visitEgoExpression(ML3Parser.EgoExpressionContext ctx) {
        return new EgoExpression(this.parseStack.peek());
    }

    @Override
    public IParseTreeNode visitEqualsExpression(ML3Parser.EqualsExpressionContext ctx) {
        EqualExpression ee = new EqualExpression(this.parseStack.peek(), ctx.Equals() == null);
        this.parseStack.push(ee);
        ee.setLeftExpression(this.visitExpression(ctx.l));
        ee.setRightExpression(this.visitExpression(ctx.r));
        this.parseStack.pop();
        return ee;
    }

    @Override
    public IParseTreeNode visitInExpression(ML3Parser.InExpressionContext ctx) {
        InExpression ie = new InExpression(this.parseStack.peek());
        this.parseStack.push(ie);
        ie.setElement(this.visitExpression(ctx.l));
        ie.setList(this.visitExpression(ctx.r));
        this.parseStack.pop();
        return ie;
    }

    @Override
    public IParseTreeNode visitOrExpression(ML3Parser.OrExpressionContext ctx) {
        OrExpression oe = new OrExpression(this.parseStack.peek());
        this.parseStack.push(oe);
        oe.setLeftExpression(this.visitExpression(ctx.l));
        oe.setRightExpression(this.visitExpression(ctx.r));
        this.parseStack.pop();
        return oe;
    }

    @Override
    public IParseTreeNode visitRelationalExpression(ML3Parser.RelationalExpressionContext ctx) {
        RelationalExpression.RelationalOperator ro = RelationalExpression.RelationalOperator.L;
        if (ctx.SmallerThan() != null) {
            ro = RelationalExpression.RelationalOperator.L;
        } else if (ctx.SmallerThanEquals() != null) {
            ro = RelationalExpression.RelationalOperator.LEQ;
        } else if (ctx.GreaterThan() != null) {
            ro = RelationalExpression.RelationalOperator.G;
        } else if (ctx.GreaterThanEquals() != null) {
            ro = RelationalExpression.RelationalOperator.GEQ;
        }
        RelationalExpression re = new RelationalExpression(this.parseStack.peek(), ro);
        this.parseStack.push(re);
        re.setLeftExpression(this.visitExpression(ctx.l));
        re.setRightExpression(this.visitExpression(ctx.r));
        this.parseStack.pop();
        return re;
    }

    @Override
    public IParseTreeNode visitUnaryExpression(ML3Parser.UnaryExpressionContext ctx) {
        UnaryExpression ue = new UnaryExpression(this.parseStack.peek(), ctx.Sub() != null ? UnaryExpression.UnaryOperator.MINUS : UnaryExpression.UnaryOperator.NOT);
        this.parseStack.push(ue);
        ue.setExpression(this.visitExpression(ctx.e));
        this.parseStack.pop();
        return ue;
    }

    @Override
    public IParseTreeNode visitAddExpression(ML3Parser.AddExpressionContext ctx) {
        AddExpression ae = new AddExpression(this.parseStack.peek(), ctx.Add() != null ? AddExpression.Operation.ADD : AddExpression.Operation.SUB);
        this.parseStack.push(ae);
        ae.setLeftSummand(this.visitExpression(ctx.l));
        ae.setRightSummand(this.visitExpression(ctx.r));
        this.parseStack.pop();
        return ae;
    }

    @Override
    public IParseTreeNode visitTernExpression(ML3Parser.TernExpressionContext ctx) {
        ConditionalExpression cond = new ConditionalExpression(this.parseStack.peek());
        this.parseStack.push(cond);
        cond.setCondition(this.visitExpression(ctx.c));
        cond.setThenExpression(this.visitExpression(ctx.t));
        cond.setElseExpression(this.visitExpression(ctx.f));
        this.parseStack.pop();
        return cond;
    }

    @Override
    public IParseTreeNode visitAllAgents(ML3Parser.AllAgentsContext ctx) {
        return new AllAgentsExpression(this.parseStack.peek(), ctx.AgentIdentifier().getText());
    }

    @Override
    public IParseTreeNode visitAndExpression(ML3Parser.AndExpressionContext ctx) {
        AndExpression ae = new AndExpression(this.parseStack.peek());
        this.parseStack.push(ae);
        ae.setLeftExpression(this.visitExpression(ctx.l));
        ae.setRightExpression(this.visitExpression(ctx.r));
        this.parseStack.pop();
        return ae;
    }

    @Override
    public IParseTreeNode visitMapAccessExpression(ML3Parser.MapAccessExpressionContext ctx) {
        MapConstantAccessExpression mae = new MapConstantAccessExpression(this.parseStack.peek(), ctx.Identifier().getText());
        this.maps.add(ctx.Identifier().getText());
        this.parseStack.push(mae);
        mae.setParameter(this.visitExpression(ctx.expression()));
        this.parseStack.pop();
        return mae;
    }

    @Override
    public IParseTreeNode visitIfElseExpression(ML3Parser.IfElseExpressionContext ctx) {
        ConditionalExpression cond = new ConditionalExpression(this.parseStack.peek());
        this.parseStack.push(cond);
        cond.setCondition(this.visitExpression(ctx.c));
        cond.setThenExpression(this.visitExpression(ctx.t));
        cond.setElseExpression(this.visitExpression(ctx.f));
        this.parseStack.pop();
        return cond;
    }

    @Override
    public IParseTreeNode visitMathFuncCallExpression(ML3Parser.MathFuncCallExpressionContext ctx) {
        FunctionCallExpression fce = new FunctionCallExpression(this.parseStack.peek(), ctx.Identifier().getText());
        this.parseStack.push(fce);
        for (int i = 0; i < ctx.expression().size(); ++i) {
            fce.getParameters().add(this.visitExpression(ctx.expression(i)));
        }
        this.parseStack.pop();
        return fce;
    }

    @Override
    public IParseTreeNode visitNewStatement(ML3Parser.NewStatementContext ctx) {
        AgentCreationStatement acs = new AgentCreationStatement(this.parseStack.peek());
        this.parseStack.push(acs);
        acs.setLeftSides(ctx.assignLeftSide().stream().map(this::visitAssignLeftSide).collect(Collectors.toList()));
        acs.setVariables(ctx.LocalIdentifier().stream().map(e -> e.getText()).collect(Collectors.toList()));
        for (ML3Parser.AgentCreationArgumentContext acac : ctx.agentCreationArgument()) {
            String identifier = acac.Age() != null ? acac.Age().getText() : acac.Identifier().getText();
            acs.getInitializations().put(identifier, this.visitExpression(acac.expression()));
        }
        acs.setAgentType(ctx.AgentIdentifier().getText());
        this.parseStack.pop();
        return acs;
    }

    @Override
    public IParseTreeNode visitAssignStatement(ML3Parser.AssignStatementContext ctx) {
        AssignmentStatement aas = new AssignmentStatement(this.parseStack.peek());
        this.parseStack.push(aas);
        aas.setRightSideExpression(this.visitExpression(ctx.expression()));
        aas.setLeftSides(ctx.assignLeftSide().stream().map(this::visitAssignLeftSide).collect(Collectors.toList()));
        this.parseStack.pop();
        return aas;
    }

    @Override
    public IParseTreeNode visitCompStatement(ML3Parser.CompStatementContext ctx) {
        CompositionStatement cs = new CompositionStatement(this.parseStack.peek());
        this.parseStack.push(cs);
        cs.setFirst(this.visitStatement(ctx.l));
        cs.setSecond(this.visitStatement(ctx.r));
        this.parseStack.pop();
        return cs;
    }

    public IStatement visitStatement(ML3Parser.StatementContext ctx) {
        return (IStatement)ctx.accept(this);
    }

    @Override
    public IParseTreeNode visitIfStatement(ML3Parser.IfStatementContext ctx) {
        ConditionalStatement cs = new ConditionalStatement(this.parseStack.peek());
        this.parseStack.push(cs);
        cs.setConditionExpression(this.visitExpression(ctx.c));
        cs.setThenStatement(this.visitStatement(ctx.t));
        if (ctx.e != null) {
            cs.setElseStatement(this.visitStatement(ctx.e));
        }
        this.parseStack.pop();
        return cs;
    }

    @Override
    public ProcedureDeclarationNode visitProcDec(ML3Parser.ProcDecContext ctx) {
        ModelNode parentNode = (ModelNode)this.parseStack.peek();
        String agentIdentifier = ctx.AgentIdentifier().getText();
        String procedureIdentifier = ctx.Identifier().getText();
        ProcedureDeclarationNode procedureDeclarationNode = new ProcedureDeclarationNode(parentNode, agentIdentifier, procedureIdentifier);
        this.parseStack.push(procedureDeclarationNode);
        procedureDeclarationNode.setParameters(ctx.paramDec().stream().map(this::visitParamDec).collect(Collectors.toList()));
        if (ctx.where() != null) {
            procedureDeclarationNode.setWhereClause(this.visitWhere(ctx.where()));
        }
        procedureDeclarationNode.setStatement(this.visitStatement(ctx.statement()));
        this.parseStack.pop();
        return procedureDeclarationNode;
    }

    @Override
    public IStatement visitProcCallStatement(ML3Parser.ProcCallStatementContext ctx) {
        ProcedureCallStatement pcs = new ProcedureCallStatement(this.parseStack.peek(), ctx.Identifier().getText());
        this.parseStack.push(pcs);
        pcs.setBaseExpression(this.visitExpression(ctx.base));
        for (int i = 1; i < ctx.expression().size(); ++i) {
            pcs.getParameterExpressions().add(this.visitExpression(ctx.expression(i)));
        }
        this.parseStack.pop();
        return pcs;
    }

    @Override
    public IRateNode visitEveryRate(ML3Parser.EveryRateContext ctx) {
        if (ctx.Synchronized() == null) {
            EveryRateNode ern = new EveryRateNode((RuleNode)this.parseStack.peek());
            this.parseStack.push(ern);
            ern.setInterval(this.visitExpression(ctx.expression()));
            this.parseStack.pop();
            return ern;
        }
        EverySynchronizedRateNode ern = new EverySynchronizedRateNode((RuleNode)this.parseStack.peek());
        this.parseStack.push(ern);
        ern.setInterval(this.visitExpression(ctx.expression()));
        this.parseStack.pop();
        return ern;
    }

    @Override
    public IParseTreeNode visitExponentialExpression(ML3Parser.ExponentialExpressionContext ctx) {
        ExponentialExpression ee = new ExponentialExpression(this.parseStack.peek());
        this.parseStack.push(ee);
        ee.setBase(this.visitExpression(ctx.l));
        ee.setExponent(this.visitExpression(ctx.r));
        this.parseStack.pop();
        return ee;
    }

    @Override
    public IStatement visitForStatement(ML3Parser.ForStatementContext ctx) {
        ForEachStatement fs = new ForEachStatement(this.parseStack.peek());
        this.parseStack.push(fs);
        fs.setVariableName(ctx.LocalIdentifier().getText());
        fs.setListExpression(this.visitExpression(ctx.expression()));
        fs.setStatement(this.visitStatement(ctx.statement()));
        this.parseStack.pop();
        return fs;
    }

    @Override
    public AssignmentLeftSideNode visitAssignLeftSide(ML3Parser.AssignLeftSideContext ctx) {
        AssignmentLeftSideNode alsn = new AssignmentLeftSideNode(this.parseStack.peek());
        this.parseStack.push(alsn);
        alsn.setAttributeName(ctx.Identifier().getText());
        alsn.setBaseExpression(this.visitExpression(ctx.expression()));
        this.parseStack.pop();
        return alsn;
    }

    @Override
    public AssignmentStatement visitAddAssignStatement(ML3Parser.AddAssignStatementContext ctx) {
        AssignmentStatement as = new AssignmentStatement(this.parseStack.peek());
        this.parseStack.push(as);
        as.addLeftSide(this.visitAssignLeftSide(ctx.assignLeftSide()));
        AddExpression ae = new AddExpression(as, ctx.AddAssign() != null ? AddExpression.Operation.ADD : AddExpression.Operation.SUB);
        AttributeAccessExpression aae = new AttributeAccessExpression(ae);
        aae.setAttributeName(ctx.assignLeftSide().Identifier().getText());
        aae.setBaseExpression(this.visitExpression(ctx.assignLeftSide().expression()));
        ae.setRightSummand(this.visitExpression(ctx.expression()));
        ae.setLeftSummand(aae);
        as.setRightSideExpression(ae);
        this.parseStack.pop();
        return as;
    }

    @Override
    public IType visitBasicType(ML3Parser.BasicTypeContext ctx) {
        if (ctx.TypeBool() != null) {
            return BasicType.BOOL;
        }
        if (ctx.TypeInt() != null) {
            return BasicType.INT;
        }
        if (ctx.TypeReal() != null) {
            return BasicType.REAL;
        }
        if (ctx.TypeString() != null) {
            return BasicType.STRING;
        }
        return this.visitEnumType(ctx.enumType());
    }

    @Override
    public IType visitType(ML3Parser.TypeContext ctx) {
        if (ctx.basicType() != null) {
            return this.visitBasicType(ctx.basicType());
        }
        if (ctx.AgentIdentifier() != null) {
            return new AgentType(ctx.getText());
        }
        return new SetType(this.visitType(ctx.type()));
    }

    @Override
    public IType visitEnumType(ML3Parser.EnumTypeContext ctx) {
        Set<String> valueSet = ctx.String().stream().map(token -> token.getText().substring(1, token.getText().length() - 1)).collect(Collectors.toSet());
        return new EnumType(valueSet);
    }

    private Cardinality evalCardinality(ML3Parser.CardinalityContext ctx) {
        if (ctx.cardinalityExactInterval() != null) {
            int value = Integer.valueOf(ctx.cardinalityExactInterval().Nat().getText());
            return Cardinality.createExactValueCardinality(value);
        }
        if (ctx.cardinalityOpenInterval() != null) {
            int min = Integer.valueOf(ctx.cardinalityOpenInterval().Nat().getText());
            return Cardinality.createOpenIntervalCardinality(min);
        }
        int min = Integer.valueOf(ctx.cardinalityClosedInterval().min.getText());
        int max = Integer.valueOf(ctx.cardinalityClosedInterval().max.getText());
        return Cardinality.createClosedIntervalCardinality(min, max);
    }
}

