/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.parser;

import java.util.HashSet;
import java.util.Set;

public class BuildIns {
    public static final String ATTRIBUTE_AGE = "age";
    public static final String AGENTFUNC_ISALIVE = "isAlive";
    public static final String SETFUNC_RANDOM = "random";
    public static final String SETFUNC_SIZE = "size";
    public static final String SETFUNC_ONLY = "only";
    public static final String SETFUNC_FILTER = "filter";
    public static final String SETFUNC_MAP = "map";
    public static final String SETFUNC_COLLECT = "collect";
    public static final String SETFUNC_EMPTY = "isEmpty";
    public static final String SETFUNC_SUM = "sum";
    public static final String SETFUNC_ARGMAX = "argmax";
    public static final String SETFUNC_ARGMIN = "argmin";
    public static final String FUNC_ABS = "abs";
    public static final String FUNC_CEIL = "ceil";
    public static final String FUNC_SQRT = "sqrt";
    public static final String FUNC_COS = "cos";
    public static final String FUNC_SIN = "sin";
    public static final String FUNC_TAN = "tan";
    public static final String FUNC_EXP = "exp";
    public static final String FUNC_FLOOR = "floor";
    public static final String FUNC_LOG = "log";
    public static final String FUNC_LOG10 = "log10";
    public static final String FUNC_MAX = "max";
    public static final String FUNC_MIN = "min";
    public static final String FUNC_ROUND = "round";
    public static final String FUNC_SIGNUM = "signum";
    public static final String FUNC_RANDOM = "random";
    public static final String FUNC_NORMAL_DIST = "normal";
    public static final String PROC_DIE = "die";
    private static final Set<String> attributes = new HashSet<String>();
    private static final Set<String> agentFunctions;
    private static final Set<String> setFunctions;
    private static final Set<String> mathFunctions;
    private static final Set<String> procedures;

    public static boolean isAttribute(String name) {
        return attributes.contains(name);
    }

    public static boolean isAgentFunction(String name) {
        return agentFunctions.contains(name);
    }

    public static boolean isSetFunction(String name) {
        return setFunctions.contains(name);
    }

    public static boolean isMathFunction(String name) {
        return mathFunctions.contains(name);
    }

    public static boolean isProcedure(String name) {
        return procedures.contains(name);
    }

    public static boolean isPredefinedFunction(String name) {
        return BuildIns.isMathFunction(name) || BuildIns.isSetFunction(name) || BuildIns.isAgentFunction(name);
    }

    public static boolean isNonMathPredefinedFunction(String name) {
        return BuildIns.isSetFunction(name) || BuildIns.isAgentFunction(name);
    }

    static {
        attributes.add(ATTRIBUTE_AGE);
        agentFunctions = new HashSet<String>();
        agentFunctions.add(AGENTFUNC_ISALIVE);
        setFunctions = new HashSet<String>();
        setFunctions.add("random");
        setFunctions.add(SETFUNC_SIZE);
        setFunctions.add(SETFUNC_ONLY);
        setFunctions.add(SETFUNC_FILTER);
        setFunctions.add(SETFUNC_MAP);
        setFunctions.add(SETFUNC_COLLECT);
        setFunctions.add(SETFUNC_EMPTY);
        setFunctions.add(SETFUNC_SUM);
        setFunctions.add(SETFUNC_ONLY);
        setFunctions.add(SETFUNC_ARGMAX);
        setFunctions.add(SETFUNC_ARGMIN);
        mathFunctions = new HashSet<String>();
        mathFunctions.add(FUNC_ABS);
        mathFunctions.add(FUNC_CEIL);
        mathFunctions.add(FUNC_SQRT);
        mathFunctions.add(FUNC_COS);
        mathFunctions.add(FUNC_SIN);
        mathFunctions.add(FUNC_TAN);
        mathFunctions.add(FUNC_EXP);
        mathFunctions.add(FUNC_FLOOR);
        mathFunctions.add(FUNC_LOG);
        mathFunctions.add(FUNC_LOG10);
        mathFunctions.add(FUNC_MAX);
        mathFunctions.add(FUNC_MIN);
        mathFunctions.add(FUNC_ROUND);
        mathFunctions.add(FUNC_SIGNUM);
        mathFunctions.add("random");
        mathFunctions.add(FUNC_NORMAL_DIST);
        procedures = new HashSet<String>();
        procedures.add(PROC_DIE);
    }
}

