/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.observation;

import java.util.function.Consumer;
import org.jamesii.core.util.misc.Pair;
import org.jamesii.ml3.model.agents.IAgent;
import org.jamesii.ml3.model.state.IState;
import org.jamesii.ml3.observation.IListener;
import org.jamesii.ml3.simulator.simulators.RuleInstance;

public class WallclockIntervalListener
implements IListener {
    private long lastNanos;
    private Consumer<Pair<Double, Long>> callback;

    public WallclockIntervalListener(Consumer<Pair<Double, Long>> callback) {
        this.callback = callback;
        this.lastNanos = System.nanoTime();
    }

    @Override
    public void notify(IState state, double now, RuleInstance instance, IAgent agent) {
        long nowNanos = System.nanoTime();
        this.callback.accept(new Pair<Double, Long>(now, nowNanos - this.lastNanos));
        this.lastNanos = nowNanos;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void finish() {
    }
}

