/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.observation;

import java.util.ArrayList;
import java.util.List;
import org.jamesii.ml3.observation.TimeTriggeredObserver;

public class TimePointListObserver
extends TimeTriggeredObserver {
    private List<Double> observationPoints;
    private int index;

    public TimePointListObserver(List<Double> observationPoints) {
        this.observationPoints = observationPoints;
    }

    public TimePointListObserver(double ... observationPoints) {
        this.observationPoints = new ArrayList<Double>(observationPoints.length);
        for (double observationPoint : observationPoints) {
            this.observationPoints.add(observationPoint);
        }
    }

    @Override
    protected double getNextObservationPoint() {
        if (this.index < this.observationPoints.size()) {
            return this.observationPoints.get(this.index);
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    protected void advanceObservationPoint() {
        ++this.index;
    }

    @Override
    protected boolean hasMandatoryNextObservationPoint() {
        return this.index < this.observationPoints.size();
    }
}

