/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.observation;

import java.util.function.Consumer;
import org.jamesii.core.util.misc.Pair;
import org.jamesii.ml3.model.Model;
import org.jamesii.ml3.model.Parameters;
import org.jamesii.ml3.model.agents.IAgent;
import org.jamesii.ml3.model.state.IState;
import org.jamesii.ml3.model.values.IValue;
import org.jamesii.ml3.observation.IListener;
import org.jamesii.ml3.parser.ParserUtil;
import org.jamesii.ml3.parser.nodes.expressions.IExpression;
import org.jamesii.ml3.simulator.context.IContext;
import org.jamesii.ml3.simulator.context.SimpleContext;
import org.jamesii.ml3.simulator.evaluate.BasicExpressionEvaluator;
import org.jamesii.ml3.simulator.evaluate.IExpressionEvaluator;
import org.jamesii.ml3.simulator.simulators.RuleInstance;

public class AgentExpressionListener
implements IListener {
    private Consumer<Pair<Double, IValue>> callback;
    private IExpressionEvaluator exev;
    private IExpression target;
    private IContext context;

    public AgentExpressionListener(Model model, Parameters parameters, String target, Consumer<Pair<Double, IValue>> callback) {
        this.callback = callback;
        this.target = ParserUtil.parseExpressionCode(target);
        this.exev = new BasicExpressionEvaluator();
        this.context = new SimpleContext();
        this.context.put((Object)IContext.Keys.MODEL, model);
        this.context.put((Object)IContext.Keys.EXPRESSION_EVALUATOR, this.exev);
        this.context.put((Object)IContext.Keys.PARAMETERS, parameters);
    }

    @Override
    public void notify(IState state, double now, RuleInstance instance, IAgent agent) {
        this.context.push();
        this.context.put((Object)IContext.Keys.TIME, now);
        this.context.put((Object)IContext.Keys.EGO, agent.asValue());
        IValue result = this.exev.getValue(this.target, this.context);
        this.context.pop();
        this.callback.accept(new Pair<Double, IValue>(now, result));
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void finish() {
    }
}

