/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.observation;

import java.util.Collection;
import org.jamesii.ml3.model.Model;
import org.jamesii.ml3.model.Parameters;
import org.jamesii.ml3.model.agents.IAgent;
import org.jamesii.ml3.model.state.IState;
import org.jamesii.ml3.model.values.BoolValue;
import org.jamesii.ml3.model.values.IValue;
import org.jamesii.ml3.observation.AbstractObserver;
import org.jamesii.ml3.parser.ParserUtil;
import org.jamesii.ml3.parser.nodes.expressions.IExpression;
import org.jamesii.ml3.simulator.context.IContext;
import org.jamesii.ml3.simulator.context.SimpleContext;
import org.jamesii.ml3.simulator.evaluate.BasicExpressionEvaluator;
import org.jamesii.ml3.simulator.evaluate.IExpressionEvaluator;
import org.jamesii.ml3.simulator.evaluate.StatementEvaluationProtocol;
import org.jamesii.ml3.simulator.simulators.RuleInstance;

public class AgentCreationObserver
extends AbstractObserver {
    private String type;
    private IExpression filter;
    private boolean useFilter;
    private IContext context;
    private IExpressionEvaluator exev;

    public AgentCreationObserver(String type) {
        this.type = type;
        this.useFilter = false;
    }

    public AgentCreationObserver(String type, String filter, Model model, Parameters parameters) {
        this.type = type;
        this.filter = ParserUtil.parseExpressionCode(filter);
        this.useFilter = true;
        this.exev = new BasicExpressionEvaluator();
        this.context = new SimpleContext();
        this.context.put((Object)IContext.Keys.MODEL, model);
        this.context.put((Object)IContext.Keys.EXPRESSION_EVALUATOR, this.exev);
        this.context.put((Object)IContext.Keys.PARAMETERS, parameters);
    }

    @Override
    public void updateBefore(IState state, double now, double timeOfNextEvent, RuleInstance instance) {
    }

    @Override
    public void updateAfter(IState state, double now, RuleInstance instance, StatementEvaluationProtocol sep) {
        Collection<IAgent> created = sep.getCreatedAgents();
        for (IAgent agent : created) {
            if (!agent.getType().equals(this.type)) continue;
            if (this.useFilter) {
                this.context.push();
                this.context.put((Object)IContext.Keys.EGO, agent.asValue());
                this.context.put((Object)IContext.Keys.TIME, now);
                IValue filterValue = this.exev.getValue(this.filter, this.context);
                if (filterValue instanceof BoolValue && ((BoolValue)filterValue).getValue().booleanValue()) {
                    this.notifyListeners(state, now, instance, agent);
                }
                this.context.pop();
                continue;
            }
            this.notifyListeners(state, now, instance, agent);
        }
    }

    @Override
    public void finish(IState state, double now) {
        this.finishListeners();
    }
}

