/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.observation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jamesii.ml3.model.agents.IAgent;
import org.jamesii.ml3.model.state.IState;
import org.jamesii.ml3.observation.IListener;
import org.jamesii.ml3.observation.IObserver;
import org.jamesii.ml3.simulator.simulators.RuleInstance;

public abstract class AbstractObserver
implements IObserver {
    private Set<IListener> listeners = new HashSet<IListener>();

    @Override
    public void registerListener(IListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(IListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public Collection<IListener> getListeners() {
        return Collections.unmodifiableSet(this.listeners);
    }

    @Override
    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    protected void notifyListeners(IState state, double now, RuleInstance instance, IAgent agent) {
        this.removeInactiveListeners();
        this.listeners.forEach(l -> l.notify(state, now, instance, agent));
    }

    protected void finishListeners() {
        this.removeInactiveListeners();
        this.listeners.forEach(l -> l.finish());
    }

    private void removeInactiveListeners() {
        this.listeners = this.listeners.stream().filter(l -> l.isActive()).collect(Collectors.toSet());
    }
}

