/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.model.values;

import org.jamesii.ml3.model.types.BasicType;
import org.jamesii.ml3.model.types.IType;
import org.jamesii.ml3.model.values.INumericalValue;
import org.jamesii.ml3.model.values.IntValue;

public class RealValue
implements INumericalValue {
    private final double value;

    public RealValue(double value) {
        this.value = value;
    }

    public RealValue(String value) {
        this(Double.parseDouble(value));
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public IType getType() {
        return BasicType.REAL;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof INumericalValue) {
            if (o instanceof IntValue) {
                int n = ((IntValue)o).getValue();
                return (double)n == this.value;
            }
            if (o instanceof RealValue) {
                RealValue value1 = (RealValue)o;
                return Double.compare(value1.value, this.value) == 0;
            }
        }
        return false;
    }

    public int hashCode() {
        if (Math.rint(this.value) == this.value) {
            return (int)this.value;
        }
        return Double.hashCode(this.value);
    }

    @Override
    public int compareTo(INumericalValue o) {
        if (o instanceof RealValue) {
            return Double.compare(this.value, ((RealValue)o).getValue());
        }
        if (o instanceof IntValue) {
            return Double.compare(this.value, ((IntValue)o).getValue().intValue());
        }
        throw new RuntimeException("Unknown subclass of NumericalValue.");
    }

    @Override
    public INumericalValue add(INumericalValue other) {
        if (other instanceof RealValue) {
            return new RealValue(((RealValue)other).getValue() + this.value);
        }
        if (other instanceof IntValue) {
            return new RealValue((double)((IntValue)other).getValue().intValue() + this.value);
        }
        throw new RuntimeException("Unknown subclass of NumericalValue.");
    }

    @Override
    public INumericalValue subtract(INumericalValue other) {
        if (other instanceof RealValue) {
            return new RealValue(this.value - ((RealValue)other).getValue());
        }
        if (other instanceof IntValue) {
            return new RealValue(this.value - (double)((IntValue)other).getValue().intValue());
        }
        throw new RuntimeException("Unknown subclass of NumericalValue.");
    }

    @Override
    public INumericalValue multiply(INumericalValue other) {
        if (other instanceof RealValue) {
            return new RealValue(((RealValue)other).getValue() * this.value);
        }
        if (other instanceof IntValue) {
            return new RealValue((double)((IntValue)other).getValue().intValue() * this.value);
        }
        throw new RuntimeException("Unknown subclass of NumericalValue.");
    }

    @Override
    public INumericalValue divide(INumericalValue other) {
        if (other instanceof RealValue) {
            return new RealValue(this.value / ((RealValue)other).getValue());
        }
        if (other instanceof IntValue) {
            return new RealValue(this.value / (double)((IntValue)other).getValue().intValue());
        }
        throw new RuntimeException("Unknown subclass of NumericalValue.");
    }

    @Override
    public INumericalValue modulo(INumericalValue other) {
        if (other instanceof RealValue) {
            return new RealValue(this.value % ((RealValue)other).getValue());
        }
        if (other instanceof IntValue) {
            return new RealValue(this.value % (double)((IntValue)other).getValue().intValue());
        }
        throw new RuntimeException("Unknown subclass of NumericalValue.");
    }

    @Override
    public INumericalValue pow(INumericalValue other) {
        if (other instanceof RealValue) {
            return new RealValue(Math.pow(this.value, ((RealValue)other).getValue()));
        }
        if (other instanceof IntValue) {
            return new RealValue(Math.pow(this.value, ((IntValue)other).getValue().intValue()));
        }
        throw new RuntimeException("Unknown subclass of NumericalValue.");
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    public String toString() {
        return Double.toString(this.value);
    }
}

