/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.model.values;

import org.jamesii.ml3.model.types.BasicType;
import org.jamesii.ml3.model.types.IType;
import org.jamesii.ml3.model.values.INumericalValue;
import org.jamesii.ml3.model.values.RealValue;

public class IntValue
implements INumericalValue {
    private int value;

    public IntValue(int value) {
        this.value = value;
    }

    public IntValue(String value) {
        this(Integer.parseInt(value));
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public IType getType() {
        return BasicType.INT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof INumericalValue) {
            if (o instanceof RealValue) {
                double d = ((RealValue)o).getValue();
                return d == (double)this.value;
            }
            IntValue value1 = (IntValue)o;
            return this.value == value1.value;
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int compareTo(INumericalValue o) {
        if (o instanceof RealValue) {
            return Double.compare(this.value, ((RealValue)o).getValue());
        }
        if (o instanceof IntValue) {
            return Integer.compare(this.value, ((IntValue)o).getValue());
        }
        throw new RuntimeException("Unknown subclass of NumericalValue.");
    }

    @Override
    public INumericalValue add(INumericalValue other) {
        if (other instanceof RealValue) {
            return new RealValue(((RealValue)other).getValue() + (double)this.value);
        }
        if (other instanceof IntValue) {
            return new IntValue(((IntValue)other).getValue() + this.value);
        }
        throw new RuntimeException("Unknown subclass of NumericalValue.");
    }

    @Override
    public INumericalValue subtract(INumericalValue other) {
        if (other instanceof RealValue) {
            return new RealValue((double)this.value - ((RealValue)other).getValue());
        }
        if (other instanceof IntValue) {
            return new IntValue(this.value - ((IntValue)other).getValue());
        }
        throw new RuntimeException("Unknown subclass of NumericalValue.");
    }

    @Override
    public INumericalValue multiply(INumericalValue other) {
        if (other instanceof RealValue) {
            return new RealValue(((RealValue)other).getValue() * (double)this.value);
        }
        if (other instanceof IntValue) {
            return new IntValue(((IntValue)other).getValue() * this.value);
        }
        throw new RuntimeException("Unknown subclass of NumericalValue.");
    }

    @Override
    public INumericalValue divide(INumericalValue other) {
        if (other instanceof RealValue) {
            return new RealValue((double)this.value / ((RealValue)other).getValue());
        }
        if (other instanceof IntValue) {
            return new RealValue((double)this.value / (double)((IntValue)other).getValue().intValue());
        }
        throw new RuntimeException("Unknown subclass of NumericalValue.");
    }

    @Override
    public INumericalValue modulo(INumericalValue other) {
        if (other instanceof RealValue) {
            return new RealValue((double)this.value % ((RealValue)other).getValue());
        }
        if (other instanceof IntValue) {
            return new IntValue(this.value % ((IntValue)other).getValue());
        }
        throw new RuntimeException("Unknown subclass of NumericalValue.");
    }

    @Override
    public INumericalValue pow(INumericalValue other) {
        if (other instanceof RealValue) {
            return new RealValue(Math.pow(this.value, ((RealValue)other).getValue()));
        }
        if (other instanceof IntValue) {
            return new IntValue((int)Math.pow(this.value, ((RealValue)other).getValue()));
        }
        throw new RuntimeException("Unknown subclass of NumericalValue.");
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }
}

