/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.model.values;

import org.jamesii.ml3.model.types.BasicType;
import org.jamesii.ml3.model.types.IType;
import org.jamesii.ml3.model.values.IValue;

public class BoolValue
implements IValue {
    public static final BoolValue TRUE = new BoolValue(true);
    public static final BoolValue FALSE = new BoolValue(false);
    private final boolean value;

    public BoolValue(boolean value) {
        this.value = value;
    }

    public BoolValue(String value) {
        this(Boolean.parseBoolean(value));
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public IType getType() {
        return BasicType.BOOL;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BoolValue)) {
            return false;
        }
        BoolValue value1 = (BoolValue)o;
        return this.value == value1.value;
    }

    public int hashCode() {
        return this.value ? 1 : 0;
    }

    public String toString() {
        return Boolean.toString(this.value);
    }
}

