/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.model.types;

import java.util.ArrayList;
import org.jamesii.ml3.model.types.AgentType;
import org.jamesii.ml3.model.types.Cardinality;
import org.jamesii.ml3.model.types.IType;
import org.jamesii.ml3.model.types.UnknownType;
import org.jamesii.ml3.model.values.IValue;
import org.jamesii.ml3.model.values.SetValue;

public final class SetType
implements IType {
    private final IType listType;
    private final Cardinality cardinality;

    public SetType(IType listType, Cardinality card) {
        this(listType, card.getLowerBound(), card.getUpperBound());
    }

    public SetType(IType listType, int lowerLimit, int upperLimit) {
        this.listType = listType;
        this.cardinality = new Cardinality(lowerLimit, upperLimit);
    }

    public SetType(IType listType) {
        this(listType, 0, Integer.MAX_VALUE);
    }

    public int getLowerLimit() {
        return this.cardinality.getLowerBound();
    }

    public int getUpperLimit() {
        return this.cardinality.getUpperBound();
    }

    @Override
    public IValue getDefaultValue() {
        ArrayList<IValue> list = new ArrayList<IValue>();
        for (int i = 0; i < this.getLowerLimit(); ++i) {
            list.add(this.getElementType().getDefaultValue());
        }
        return new SetValue();
    }

    @Override
    public boolean isValidValue(IValue value) {
        if (!this.equals(value.getType())) {
            return false;
        }
        int size = ((SetValue)value).getValue().size();
        return size >= this.getLowerLimit() && size <= this.getUpperLimit();
    }

    @Override
    public boolean areCompatible(IType type) {
        return this.getElementType().areCompatible(type);
    }

    public String toString() {
        return "[" + this.listType.toString() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SetType)) {
            return false;
        }
        SetType type = (SetType)o;
        return type.cardinality.equals(this.cardinality) && (this.listType.equals(type.listType) || this.listType instanceof UnknownType);
    }

    public int hashCode() {
        int result = this.listType.hashCode() * (this.listType instanceof UnknownType ? 0 : 1);
        result = 31 * result + this.cardinality.hashCode();
        return result;
    }

    public static SetType fromLink(String agentType, Cardinality c) {
        return new SetType(new AgentType(agentType), c);
    }

    public IType getElementType() {
        return this.listType;
    }

    public Cardinality getCardinality() {
        return this.cardinality;
    }
}

