/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.model.types;

public class Cardinality {
    private static final int UNDEFINDED_EXTREME = -1;
    private final int minimum;
    private final int maximum;

    public static Cardinality createExactValueCardinality(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("The value of an exact value cardinality must be bigger than 0.");
        }
        return new Cardinality(value, value);
    }

    public static Cardinality createOpenIntervalCardinality(int minimum) {
        if (minimum < 0) {
            throw new IllegalArgumentException("The minimum of an open interval cardinality must be bigger than 0.");
        }
        return new Cardinality(minimum, -1);
    }

    public static Cardinality createClosedIntervalCardinality(int minimum, int maximum) {
        if (minimum < 0) {
            throw new IllegalArgumentException("The minimum of a closed interval cardinality must be bigger than 0.");
        }
        if (maximum < minimum) {
            throw new IllegalArgumentException("The maximum of a closed interval cardinality must be bigger than or equal the minimum.");
        }
        return new Cardinality(minimum, maximum);
    }

    public Cardinality(int minimum, int maximum) {
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public boolean isExactValue() {
        return this.minimum == this.maximum;
    }

    public boolean isOpenInterval() {
        return this.maximum < this.minimum;
    }

    public boolean isClosedInterval() {
        return this.maximum >= this.minimum;
    }

    public int getUpperBound() {
        return this.maximum;
    }

    public int getLowerBound() {
        return this.minimum;
    }

    public String toString() {
        return "[" + this.minimum + (this.minimum == this.maximum ? "" : "-") + (this.minimum == this.maximum || this.maximum == -1 ? "" : Integer.valueOf(this.maximum)) + "]";
    }

    public int hashCode() {
        return 31 * this.minimum + this.maximum;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Cardinality)) {
            return false;
        }
        Cardinality oc = (Cardinality)o;
        return oc.maximum == this.maximum && oc.minimum == this.minimum;
    }
}

