/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.model.state.writers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import org.jamesii.ml3.model.Model;
import org.jamesii.ml3.model.agents.AttributeDeclaration;
import org.jamesii.ml3.model.agents.IAgent;
import org.jamesii.ml3.model.agents.LinkDeclaration;
import org.jamesii.ml3.model.state.IState;
import org.jamesii.ml3.model.state.writers.AbstractStateWriter;
import org.jamesii.ml3.model.state.writers.StateWriteException;
import org.jamesii.ml3.model.values.BoolValue;
import org.jamesii.ml3.model.values.IValue;
import org.jamesii.ml3.model.values.IntValue;
import org.jamesii.ml3.model.values.RealValue;
import org.jamesii.ml3.model.values.StringValue;

public class JsonStateWriter
extends AbstractStateWriter {
    private final Model model;
    private Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public JsonStateWriter(String pattern, Model model) {
        super(pattern);
        this.model = model;
    }

    public JsonStateWriter(File file, Model model) throws IOException {
        super(file);
        this.model = model;
    }

    public JsonStateWriter(OutputStream out, Model model) {
        super(out);
        this.model = model;
    }

    @Override
    protected void write(OutputStream outputStream, IState state, double now) throws StateWriteException {
        JsonObject jsonState = this.createJsonState(state, now);
        try {
            outputStream.write(this.gson.toJson((JsonElement)jsonState).getBytes(Charset.forName("UTF-8")));
        }
        catch (IOException e) {
            throw new StateWriteException(e);
        }
    }

    private JsonObject createJsonState(IState state, double now) {
        JsonObject jsonState = new JsonObject();
        jsonState.addProperty("time", (Number)now);
        JsonArray agents = new JsonArray();
        for (IAgent agent : state.getAgents()) {
            agents.add((JsonElement)this.createJsonAgent(agent));
        }
        jsonState.add("agents", (JsonElement)agents);
        return jsonState;
    }

    private JsonObject createJsonAgent(IAgent agent) {
        String key;
        JsonObject jsonAgent = new JsonObject();
        jsonAgent.addProperty("id", (Number)agent.getID());
        jsonAgent.addProperty("type", agent.getType());
        jsonAgent.addProperty("alive", Boolean.valueOf(agent.isAlive()));
        jsonAgent.addProperty("birth", (Number)agent.getTimeOfBirth());
        jsonAgent.addProperty("death", (Number)agent.getTimeOfDeath());
        for (AttributeDeclaration ad : this.model.getAgentDeclaration(agent.getType()).getAttributes()) {
            key = JsonStateWriter.getJsonAttributeName(ad.getName());
            IValue value = agent.getAttributeValue(ad.getName());
            if (value instanceof StringValue) {
                jsonAgent.addProperty(key, ((StringValue)value).getValue());
                continue;
            }
            if (value instanceof IntValue) {
                jsonAgent.addProperty(key, (Number)((IntValue)value).getValue());
                continue;
            }
            if (value instanceof RealValue) {
                jsonAgent.addProperty(key, (Number)((RealValue)value).getValue());
                continue;
            }
            if (!(value instanceof BoolValue)) continue;
            jsonAgent.addProperty(key, ((BoolValue)value).getValue());
        }
        for (LinkDeclaration ld : this.model.getAgentDeclaration(agent.getType()).getLinks()) {
            key = JsonStateWriter.getJsonLinkName(ld.getPartnerRole());
            Collection<IAgent> partners = agent.getLinkedAgents(ld.getPartnerRole());
            JsonArray jsonPartners = new JsonArray();
            for (IAgent partner : partners) {
                jsonPartners.add((Number)partner.getID());
            }
            jsonAgent.add(key, (JsonElement)jsonPartners);
        }
        return jsonAgent;
    }

    public static String getJsonAttributeName(String ml3AttributeName) {
        return "_attr_" + ml3AttributeName;
    }

    public static String getJsonLinkName(String ml3LinkName) {
        return "_link_" + ml3LinkName;
    }
}

