/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.model.state;

import java.util.Collection;
import java.util.Collections;
import org.jamesii.ml3.model.agents.IAgent;
import org.jamesii.ml3.model.state.IState;

public class UnmodifiableState
implements IState {
    IState state;

    public UnmodifiableState(IState state) {
        this.state = state;
    }

    @Override
    public Collection<IAgent> getAgents() {
        return Collections.unmodifiableCollection(this.state.getAgents());
    }

    @Override
    public Collection<IAgent> getAgentsByType(String type) {
        return Collections.unmodifiableCollection(this.state.getAgentsByType(type));
    }

    @Override
    public Collection<IAgent> getAgentsAlive() {
        return Collections.unmodifiableCollection(this.state.getAgentsAlive());
    }

    @Override
    public Collection<IAgent> getAgentsAliveByType(String type) {
        return Collections.unmodifiableCollection(this.state.getAgentsAliveByType(type));
    }

    @Override
    public IAgent getAgent(int id) {
        return this.state.getAgent(id);
    }

    @Override
    public void addAgent(IAgent agent) {
        throw new UnsupportedOperationException("UnmodifiableState does not support modifications of the state.");
    }

    @Override
    public void addAgents(Collection<IAgent> agents) {
        throw new UnsupportedOperationException("UnmodifiableState does not support modifications of the state.");
    }

    @Override
    public void killAgent(int id, double time) {
        throw new UnsupportedOperationException("UnmodifiableState does not support modifications of the state.");
    }
}

