/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.model.maps;

import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.jamesii.ml3.model.maps.IValueMap;
import org.jamesii.ml3.model.values.INumericalValue;
import org.jamesii.ml3.model.values.IValue;

public class ContinuousValueMap
implements IValueMap {
    private NavigableMap<Double, IValue> map = new TreeMap<Double, IValue>();
    private IValue defaultValue;

    public ContinuousValueMap(IValue defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public void put(IValue key, IValue value) {
        this.map.put(((INumericalValue)key).getDouble(), value);
    }

    @Override
    public IValue get(IValue key) {
        if (key instanceof INumericalValue) {
            INumericalValue rkey = (INumericalValue)key;
            if (!this.map.isEmpty() && rkey.getDouble() >= (Double)this.map.firstKey()) {
                return this.map.floorEntry(rkey.getDouble()).getValue();
            }
            return this.defaultValue;
        }
        return null;
    }

    public List<Double> getBorders() {
        ArrayList<Double> keys = new ArrayList<Double>();
        keys.addAll(this.map.navigableKeySet());
        return keys;
    }

    public List<Double> getBorders(double offset) {
        ArrayList<Double> keys = new ArrayList<Double>();
        for (double cp : this.map.navigableKeySet()) {
            keys.add(cp + offset);
        }
        return keys;
    }

    @Override
    public List<IValue> getValues() {
        ArrayList<IValue> values = new ArrayList<IValue>();
        values.add(this.defaultValue);
        values.addAll(this.map.values());
        return values;
    }

    public String toString() {
        return this.map.toString();
    }

    public void setDefault(IValue v) {
        this.defaultValue = v;
    }
}

