/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.model.agents.rules;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jamesii.ml3.model.agents.rules.RuleInstanciation;
import org.jamesii.ml3.model.agents.rules.VariableBinding;
import org.jamesii.ml3.model.agents.rules.rates.IRate;
import org.jamesii.ml3.parser.nodes.expressions.IExpression;
import org.jamesii.ml3.parser.nodes.statements.IStatement;

public class Rule {
    private int id;
    private IExpression guard;
    private IRate rate;
    private IStatement effect;
    private Map<String, RuleInstanciation> instanciations;
    private Map<String, VariableBinding> variables;

    public Rule(int id, IExpression guard, IRate rate, IStatement effect) {
        this.id = id;
        this.guard = guard;
        this.rate = rate;
        this.effect = effect;
        this.instanciations = new HashMap<String, RuleInstanciation>();
        this.variables = new HashMap<String, VariableBinding>();
    }

    public Rule(int id, IExpression guard, IRate rate, IStatement effect, List<RuleInstanciation> instanciations, List<VariableBinding> variables) {
        this.id = id;
        this.guard = guard;
        this.rate = rate;
        this.effect = effect;
        this.instanciations = new HashMap<String, RuleInstanciation>();
        for (RuleInstanciation instanciation : instanciations) {
            this.instanciations.put(instanciation.getCandidateName(), instanciation);
        }
        this.variables = new HashMap<String, VariableBinding>();
        for (VariableBinding variable : variables) {
            this.variables.put(variable.getVariable(), variable);
        }
    }

    public IExpression getGuard() {
        return this.guard;
    }

    public IRate getRate() {
        return this.rate;
    }

    public IStatement getEffect() {
        return this.effect;
    }

    public int getID() {
        return this.id;
    }

    public Map<String, RuleInstanciation> getInstanciations() {
        return this.instanciations;
    }

    public Map<String, VariableBinding> getVariables() {
        return this.variables;
    }

    public String toString() {
        return "Rule" + this.id;
    }
}

