/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.model.agents;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jamesii.ml3.model.agents.IAgent;
import org.jamesii.ml3.model.values.AgentValue;
import org.jamesii.ml3.model.values.IValue;

public class SimpleAgent
implements IAgent {
    private int id;
    private double timeOfBirth;
    private double timeOfDeath = -1.0;
    private String agentType;
    private Map<String, IValue> attributes;
    private Map<String, Set<IAgent>> links;
    private AgentValue value;

    public SimpleAgent(int id, String agentType, double timeOfBirth, double timeOfDeath, Map<String, IValue> attributes, Map<String, Set<IAgent>> links) {
        this.id = id;
        this.timeOfBirth = timeOfBirth;
        this.timeOfDeath = timeOfDeath;
        this.agentType = agentType;
        this.attributes = attributes;
        this.links = links;
        this.value = new AgentValue(this);
    }

    @Override
    public boolean isAlive() {
        return this.timeOfDeath < 0.0;
    }

    @Override
    public void die(double timeOfDeath) {
        this.timeOfDeath = timeOfDeath;
    }

    @Override
    public double getTimeOfDeath() {
        return this.timeOfDeath;
    }

    @Override
    public double getTimeOfBirth() {
        return this.timeOfBirth;
    }

    @Override
    public double getAge(double time) {
        return time - this.timeOfBirth;
    }

    @Override
    public String getType() {
        return this.agentType;
    }

    @Override
    public IValue getAttributeValue(String name) {
        return this.attributes.get(name);
    }

    @Override
    public void setAttributeValue(String name, IValue value) {
        this.attributes.put(name, value);
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public Map<String, IValue> getAttributes() {
        return this.attributes;
    }

    @Override
    public void addLink(String linkName, IAgent other) {
        if (other == this) {
            throw new RuntimeException("Tried to link agent to itself.");
        }
        this.links.get(linkName).add(other);
    }

    @Override
    public void removeLink(String linkName, IAgent other) {
        this.links.get(linkName).remove(other);
    }

    @Override
    public Collection<IAgent> getLinkedAgents(String linkName) {
        return this.links.get(linkName);
    }

    @Override
    public void setLink(String linkName, Collection<IAgent> other) {
        HashSet<IAgent> linked = new HashSet<IAgent>();
        if (linked.contains(this)) {
            throw new RuntimeException("Tried to link agent to itself.");
        }
        linked.addAll(other);
        this.links.put(linkName, linked);
    }

    public String toString() {
        String ret = this.agentType + ":" + this.id;
        ret = ret + ":[" + (!this.isAlive() ? "DEAD, " : "") + "birth=" + this.timeOfBirth + ", " + String.join((CharSequence)", ", this.attributes.keySet().stream().map(e -> e + "=" + this.attributes.get(e)).collect(Collectors.toList()));
        if (!this.links.isEmpty()) {
            if (!this.attributes.isEmpty()) {
                ret = ret + ", ";
            }
            ret = ret + String.join((CharSequence)", ", this.links.keySet().stream().map(e -> e + "=[" + String.join((CharSequence)", ", this.links.get(e).stream().map(a -> a.getType() + ":" + a.getID()).collect(Collectors.toList())) + "]").collect(Collectors.toList()));
        }
        ret = ret + "]";
        return ret;
    }

    public boolean equals(Object other) {
        if (!(other instanceof IAgent)) {
            return false;
        }
        return this.id == ((IAgent)other).getID();
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    public AgentValue asValue() {
        return this.value;
    }
}

