/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.model.agents;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jamesii.ml3.model.agents.AttributeDeclaration;
import org.jamesii.ml3.model.agents.FunctionDefinition;
import org.jamesii.ml3.model.agents.LinkDeclaration;
import org.jamesii.ml3.model.agents.ProcedureDefinition;
import org.jamesii.ml3.model.agents.rules.Rule;

public class AgentDeclaration {
    private String name;
    private Map<String, AttributeDeclaration> attributes;
    private Map<String, LinkDeclaration> links;
    private Map<Integer, Rule> rules;
    private Map<String, FunctionDefinition> functions;
    private Map<String, ProcedureDefinition> procedures;

    public AgentDeclaration(String name) {
        this.name = name;
        this.attributes = new HashMap<String, AttributeDeclaration>();
        this.links = new HashMap<String, LinkDeclaration>();
        this.rules = new HashMap<Integer, Rule>();
        this.functions = new HashMap<String, FunctionDefinition>();
        this.procedures = new HashMap<String, ProcedureDefinition>();
    }

    public AgentDeclaration(String name, Collection<AttributeDeclaration> attributes, Collection<LinkDeclaration> links, Collection<Rule> rules, Collection<FunctionDefinition> functions, Collection<ProcedureDefinition> procedures) {
        this.name = name;
        this.attributes = new HashMap<String, AttributeDeclaration>();
        for (AttributeDeclaration attrDec : attributes) {
            this.attributes.put(attrDec.getName(), attrDec);
        }
        this.links = new HashMap<String, LinkDeclaration>();
        for (LinkDeclaration linkDec : links) {
            this.links.put(linkDec.getPartnerRole(), linkDec);
        }
        this.rules = new HashMap<Integer, Rule>();
        for (Rule rule : rules) {
            this.rules.put(rule.getID(), rule);
        }
        this.functions = new HashMap<String, FunctionDefinition>();
        for (FunctionDefinition funDef : functions) {
            this.functions.put(funDef.getName(), funDef);
        }
        this.procedures = new HashMap<String, ProcedureDefinition>();
        for (ProcedureDefinition procDef : procedures) {
            this.procedures.put(procDef.getName(), procDef);
        }
    }

    public String getName() {
        return this.name;
    }

    public Rule getRule(int id) {
        return this.rules.get(id);
    }

    public Collection<Rule> getRules() {
        return this.rules.values();
    }

    public void addRule(Rule rule) {
        this.rules.put(rule.getID(), rule);
    }

    public AttributeDeclaration getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Collection<AttributeDeclaration> getAttributes() {
        return this.attributes.values();
    }

    public void addAttribute(AttributeDeclaration attribute) {
        this.attributes.put(attribute.getName(), attribute);
    }

    public LinkDeclaration getLink(String name) {
        return this.links.get(name);
    }

    public Collection<LinkDeclaration> getLinks() {
        return this.links.values();
    }

    public void addLink(LinkDeclaration link) {
        this.links.put(link.getPartnerRole(), link);
    }

    public FunctionDefinition getFunction(String name) {
        return this.functions.get(name);
    }

    public Collection<FunctionDefinition> getFunctions() {
        return this.functions.values();
    }

    public void addFunction(FunctionDefinition funDef) {
        this.functions.put(funDef.getName(), funDef);
    }

    public ProcedureDefinition getProcedure(String name) {
        return this.procedures.get(name);
    }

    public Collection<ProcedureDefinition> getProcedures() {
        return this.procedures.values();
    }

    public void addProcedure(ProcedureDefinition procDef) {
        this.procedures.put(procDef.getName(), procDef);
    }

    public MemberType getMemberType(String name) {
        if (name.equals("age")) {
            return MemberType.AGE;
        }
        if (this.attributes.containsKey(name)) {
            return MemberType.ATTRIBUTE;
        }
        if (this.links.containsKey(name)) {
            return MemberType.LINK;
        }
        if (this.functions.containsKey(name)) {
            return MemberType.FUNCTION;
        }
        if (this.procedures.containsKey(name)) {
            return MemberType.PROCEDURE;
        }
        return MemberType.NONE;
    }

    public static enum MemberType {
        ATTRIBUTE,
        LINK,
        FUNCTION,
        PROCEDURE,
        NONE,
        AGE;

    }
}

