/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.core.util.eventset.calendar;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jamesii.core.util.eventset.calendar.SortOrder;

public class SortedList<E extends Comparable<E>>
implements Serializable,
Collection<E> {
    private static final long serialVersionUID = 4588220938379860909L;
    private List<E> list;
    private SortOrder order = SortOrder.ASCENDING;

    public SortedList() {
        this.list = new ArrayList();
    }

    public SortedList(List<E> unsortedData) {
        this();
        this.addAll(unsortedData);
    }

    public SortedList(int initialCapacity) {
        this.list = new ArrayList(initialCapacity);
    }

    public SortedList(int initialCapacity, SortOrder sortOrder) {
        this(initialCapacity);
        this.order = sortOrder;
    }

    public SortedList(SortOrder sortOrder) {
        this();
        this.order = sortOrder;
    }

    @Override
    public boolean add(E e) {
        int mid = this.getPos(e);
        this.list.add(mid, e);
        return true;
    }

    public final void addAll(List<E> unsortedList) {
        for (Comparable e : unsortedList) {
            this.add((E)e);
        }
    }

    public E extractTop() {
        if (this.list.isEmpty()) {
            return null;
        }
        return (E)((Comparable)this.list.remove(0));
    }

    public E get(int index) {
        return (E)((Comparable)this.list.get(index));
    }

    public List<E> getList() {
        return this.list;
    }

    public int getPos(E e) {
        int left = 0;
        int right = this.list.size();
        int mid = 0;
        while (left < right) {
            mid = (left + right) / 2;
            if (this.order == SortOrder.ASCENDING && ((Comparable)this.list.get(mid)).compareTo(e) < 0 || this.order == SortOrder.DESCENDING && ((Comparable)this.list.get(mid)).compareTo(e) > 0) {
                left = mid + 1;
                continue;
            }
            right = mid;
        }
        return left;
    }

    public int indexOf(E e) {
        return this.list.indexOf(e);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public boolean remove(E e) {
        int i;
        for (i = this.getPos(e); i < this.list.size() && ((Comparable)this.list.get(i)).compareTo(e) != 0; ++i) {
        }
        if (i >= 0) {
            if (i == 0 && this.list.isEmpty()) {
                return false;
            }
            if (i == this.list.size()) {
                return false;
            }
            if (((Comparable)this.list.get(i)).compareTo(e) != 0) {
                return false;
            }
            this.list.remove(i);
            return true;
        }
        return false;
    }

    public E remove(int index) {
        Comparable e = (Comparable)this.list.get(index);
        this.list.remove(index);
        return (E)e;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    public E top() {
        return (E)((Comparable)this.list.get(0));
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean result = true;
        for (Comparable e : c) {
            result &= this.add((E)e);
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }
}

