/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.core.util.eventset.calendar;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jamesii.core.util.eventset.AbstractEventQueue;
import org.jamesii.core.util.eventset.Entry;
import org.jamesii.core.util.eventset.calendar.SortedList;

public class DynamicCalendarQueue<E>
extends AbstractEventQueue<E, Double> {
    private static final long serialVersionUID = 3174997486320091471L;
    private int botThreshold;
    private List<SortedList<Entry<E, Double>>> bucket = new ArrayList<SortedList<Entry<E, Double>>>();
    private double buckettop;
    private int firstsub;
    private Map<E, Double> infEntries = new HashMap<E, Double>();
    private int lastbucket;
    private double lastprio;
    private int nbuckets;
    private int qsize;
    private boolean resizeenabled = true;
    private int topThreshold;
    private double width;
    private int sumEnqueueCnt;
    private int enqSearch;
    private int[] bucketsSize;

    public DynamicCalendarQueue() {
        this(2);
    }

    public DynamicCalendarQueue(int initialsize) {
        this.localinit(0, initialsize, 1.0, 0.0);
    }

    @Override
    public Entry<E, Double> dequeue() {
        if (this.qsize == 0 && this.infEntries.size() > 0) {
            Iterator<Map.Entry<E, Double>> it = this.infEntries.entrySet().iterator();
            Map.Entry<E, Double> me = it.next();
            it.remove();
            return new Entry<E, Comparable>(me.getKey(), me.getValue());
        }
        if (this.lastbucket > this.nbuckets) {
            System.out.println("lastbucket is larger as the number of buckets, ups.");
        }
        if (this.lastbucket == this.nbuckets) {
            System.out.println("we are in the last bucket");
        }
        Entry<E, Double> e = null;
        if (this.qsize == 0) {
            return null;
        }
        int i = this.lastbucket;
        do {
            SortedList<Entry<E, Double>> buck;
            if ((buck = this.bucket.get(i)) != null && !buck.isEmpty() && buck.top().getTime().compareTo(this.buckettop) < 0) {
                e = buck.extractTop();
                this.lastbucket = i;
                this.lastprio = e.getTime();
                --this.qsize;
                if (this.qsize < this.botThreshold) {
                    this.resize(this.nbuckets / 2);
                }
                return e;
            }
            if (++i == this.nbuckets) {
                i = 0;
            }
            this.buckettop += this.width;
        } while (i != this.lastbucket);
        this.lastprio = Double.POSITIVE_INFINITY;
        for (i = 0; i < this.bucket.size(); ++i) {
            Entry<E, Double> ent;
            SortedList<Entry<E, Double>> ts = this.bucket.get(i);
            if (ts == null || ts.isEmpty() || (ent = ts.top()).getTime().compareTo(this.lastprio) != -1) continue;
            this.lastprio = ent.getTime();
            this.lastbucket = i;
            this.buckettop = this.width + this.lastprio;
        }
        return this.dequeue();
    }

    @Override
    public Double dequeue(E event) {
        if (this.infEntries.remove(event) == null) {
            for (SortedList<Entry<E, Double>> list : this.bucket) {
                if (list == null) continue;
                Iterator<Entry<E, Double>> eit = list.iterator();
                while (eit.hasNext()) {
                    Entry<E, Double> e = eit.next();
                    if (e.getEvent() != event) continue;
                    eit.remove();
                    --this.qsize;
                    return e.getTime();
                }
            }
        } else {
            return Double.POSITIVE_INFINITY;
        }
        return null;
    }

    protected void dequeue(E event, Double oldTime) {
        int i = (int)(oldTime / this.width);
        SortedList<Entry<E, Double>> buck = this.bucket.get(i %= this.nbuckets);
        if (buck != null) {
            Iterator<Entry<E, Double>> it = buck.iterator();
            while (it.hasNext()) {
                Entry<E, Double> e = it.next();
                if (e.getEvent() != event || e.getTime().compareTo(oldTime) != 0) continue;
                it.remove();
                --this.qsize;
                break;
            }
        }
    }

    @Override
    public ArrayList<E> dequeueAll() {
        if (this.qsize == 0) {
            ArrayList<E> res = new ArrayList<E>(this.infEntries.keySet());
            this.infEntries.clear();
            return res;
        }
        ArrayList<E> result = new ArrayList<E>();
        Entry<E, Double> firstOne = this.dequeue();
        double b_lastprio = this.lastprio;
        Entry<E, Double> e = firstOne;
        while (e != null && e.getTime().compareTo(firstOne.getTime()) == 0) {
            result.add(e.getEvent());
            e = this.dequeue();
        }
        this.lastprio = b_lastprio;
        if (e != null) {
            this.enqueue(e.getEvent(), e.getTime());
        }
        return result;
    }

    @Override
    public List<E> dequeueAll(Double time) {
        if (time == Double.POSITIVE_INFINITY) {
            ArrayList<E> res = new ArrayList<E>(this.infEntries.keySet());
            this.infEntries.clear();
            return res;
        }
        int i = (int)(time / this.width);
        SortedList<Entry<E, Double>> buck = this.bucket.get(i %= this.nbuckets);
        if (buck == null) {
            return Collections.emptyList();
        }
        List<Entry<E, Double>> list = buck.getList();
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Entry<E, Double>> it = list.iterator();
        while (it.hasNext()) {
            Entry<E, Double> e = it.next();
            if (e.getTime().compareTo(time) != 0) continue;
            result.add(e.getEvent());
            it.remove();
            --this.qsize;
        }
        return result;
    }

    @Override
    public Map<E, Object> dequeueAllHashed() {
        HashMap result = new HashMap();
        if (this.qsize == 0) {
            for (E k : this.infEntries.keySet()) {
                result.put(k, null);
            }
            this.infEntries.clear();
            return result;
        }
        List res = this.dequeueAll();
        for (int i = 0; i < res.size(); ++i) {
            result.put(res.get(i), null);
        }
        return result;
    }

    @Override
    public void enqueue(E event, Double priority) {
        if (priority == Double.POSITIVE_INFINITY) {
            this.infEntries.put(event, priority);
            return;
        }
        int i = (int)(priority / this.width);
        SortedList<Entry<E, Double>> buck = this.bucket.get(i %= this.nbuckets);
        if (buck == null) {
            buck = new SortedList();
            this.bucket.set(i, buck);
        }
        Entry<E, Double> newEntry = new Entry<E, Double>(event, priority);
        this.insert(newEntry, buck);
        int EnqCnt = buck.getPos(newEntry);
        ++this.qsize;
        if (this.qsize > this.topThreshold) {
            this.resize(2 * this.nbuckets);
            this.sumEnqueueCnt = 0;
            this.enqSearch = 0;
        } else {
            this.sumEnqueueCnt += EnqCnt;
            ++this.enqSearch;
            if (this.enqSearch > this.nbuckets) {
                if (this.sumEnqueueCnt / this.enqSearch > 3) {
                    this.resize(this.nbuckets);
                } else {
                    this.enqSearch = 0;
                    this.sumEnqueueCnt = 0;
                }
            }
        }
    }

    private String getBucketString(SortedList<Entry<E, Double>> subList) {
        if (subList == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Entry<E, Double> m : subList.getList()) {
            stringBuilder.append(m.getTime());
            stringBuilder.append(" --- ");
            stringBuilder.append(m.getEvent());
            stringBuilder.append(" ### ");
        }
        return stringBuilder.toString();
    }

    protected Entry<E, Double> getLeast(ArrayList<Entry<E, Double>> list) {
        Double min = Double.POSITIVE_INFINITY;
        Entry<E, Double> result = null;
        for (Entry<E, Double> e : list) {
            if (min.compareTo(e.getTime()) <= 0) continue;
            min = e.getTime();
            result = e;
        }
        return result;
    }

    @Override
    public Double getMin() {
        if (this.isEmpty()) {
            return null;
        }
        Double t = Double.POSITIVE_INFINITY;
        int c = 0;
        for (SortedList<Entry<E, Double>> al : this.bucket) {
            if (al != null && !al.isEmpty() && al.top().getTime().compareTo(t) < 0) {
                t = al.top().getTime();
            }
            ++c;
        }
        return t;
    }

    public String getString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (SortedList<Entry<E, Double>> subList : this.bucket) {
            stringBuilder.append(this.getBucketString(subList));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public Double getTime(E event) {
        for (int i = 0; i < this.nbuckets; ++i) {
            SortedList<Entry<E, Double>> buck = this.bucket.get(i);
            if (buck == null) continue;
            for (Entry<E, Double> e : buck) {
                if (e.getEvent() != event) continue;
                return e.getTime();
            }
        }
        Double result = this.infEntries.get(event);
        return result;
    }

    public void initqueue() {
        this.localinit(0, 2, 1.0, 0.0);
        this.resizeenabled = true;
    }

    protected void insert(Entry<E, Double> e, SortedList<Entry<E, Double>> intoBucket) {
        intoBucket.add(e);
    }

    @Override
    public boolean isEmpty() {
        return this.qsize == 0 && this.infEntries.isEmpty();
    }

    public void localinit(int qbase, int nbuck, double bwidth, double startprio) {
        int i;
        this.firstsub = qbase;
        this.width = bwidth;
        this.nbuckets = nbuck;
        this.bucketsSize = new int[nbuck];
        for (i = 0; i < nbuck; ++i) {
            this.bucketsSize[i] = 0;
        }
        if (this.bucket == null) {
            this.bucket = new ArrayList<SortedList<Entry<E, Double>>>(this.nbuckets);
        }
        this.qsize = 0;
        for (i = 0; i < this.nbuckets; ++i) {
            this.bucket.add(i, null);
        }
        this.lastprio = startprio;
        int n = (int)(startprio / this.width);
        this.lastbucket = n % this.nbuckets;
        this.buckettop = (double)(n + 1) * this.width + 0.5 * this.width;
        this.botThreshold = this.nbuckets / 2 - 2;
        this.topThreshold = 2 * this.nbuckets;
    }

    double newwidth() {
        if (this.qsize < 2) {
            return 1.0;
        }
        int nsamples = this.qsize <= 5 ? this.qsize : 5 + this.qsize / 10;
        if (nsamples > 25) {
            nsamples = 25;
        }
        double average = 0.0;
        double b_lastprio = this.lastprio;
        int b_lastbucket = this.lastbucket;
        double b_buckettop = this.buckettop;
        this.resizeenabled = false;
        ArrayList<Entry<E, Double>> list = new ArrayList<Entry<E, Double>>();
        for (int i = 1; i < nsamples; ++i) {
            list.add(this.dequeue());
        }
        double[] prios = new double[nsamples - 1];
        for (int i = 1; i < nsamples; ++i) {
            Entry l = (Entry)list.get(i - 1);
            Double prio = (Double)l.getTime();
            this.enqueue(l.getEvent(), prio);
            prios[i - 1] = prio;
            average += prio.doubleValue();
        }
        if (Double.compare(average /= (double)nsamples, 0.0) == 0) {
            average = 1.0;
        }
        this.resizeenabled = true;
        this.lastprio = b_lastprio;
        this.lastbucket = b_lastbucket;
        this.buckettop = b_buckettop;
        return 3.0 * average;
    }

    public void print(PrintStream out) {
        int i = 0;
        for (SortedList<Entry<E, Double>> sortedList : this.bucket) {
            out.print(i++ + ": ");
            this.printBucket(sortedList, out);
            out.println();
        }
        for (Map.Entry entry : this.infEntries.entrySet()) {
            out.print(entry.getValue() + " --- " + entry.getKey() + " ### ");
        }
    }

    private void printBucket(SortedList<Entry<E, Double>> subList, PrintStream out) {
        out.print(this.getBucketString(subList));
    }

    public void printInfo() {
        System.out.println("CalendarQueue - debug info ");
        this.print(System.out);
        System.out.println("lastprio " + this.lastprio);
        System.out.println("lastbucket " + this.lastbucket);
        System.out.println("width " + this.width);
        System.out.println("nbuckets " + this.nbuckets);
        System.out.println("buckettop " + this.buckettop);
        System.out.println("qsize " + this.qsize);
        System.out.println("firstsub " + this.firstsub);
        System.out.println("top_treshold " + this.topThreshold);
        System.out.println("bot_treshold " + this.botThreshold);
    }

    @Override
    public void requeue(E event, Double newTime) {
        this.requeueIt(event, newTime);
    }

    @Override
    public void requeue(E event, Double oldTime, Double newTime) {
        if (this.infEntries.remove(event) != null) {
            this.enqueue(event, newTime);
            return;
        }
        if (oldTime != null) {
            this.dequeue(event, oldTime);
            this.enqueue(event, newTime);
        } else {
            this.requeueIt(event, newTime);
        }
    }

    protected void requeueIt(E event, Double newTime) {
        boolean found = this.infEntries.remove(event) != null;
        for (int i = 0; i < this.nbuckets && !found; ++i) {
            SortedList<Entry<E, Double>> buck = this.bucket.get(i);
            if (buck == null) continue;
            int r = -1;
            for (int j = 0; j < buck.size() && !found; ++j) {
                Entry<E, Double> e = buck.get(j);
                if (e.getEvent() != event) continue;
                found = true;
                r = j;
            }
            if (!found) continue;
            buck.remove(r);
            --this.qsize;
            break;
        }
        this.enqueue(event, newTime);
    }

    protected void resize(int newsize) {
        if (!this.resizeenabled) {
            return;
        }
        double bwidth = this.newwidth();
        List<SortedList<Entry<E, Double>>> oldbucket = this.bucket;
        this.bucket = null;
        this.localinit(0, newsize, bwidth, this.lastprio);
        this.resizeenabled = false;
        for (SortedList<Entry<E, Double>> list : oldbucket) {
            if (list == null) continue;
            for (Entry<E, Double> e : list.getList()) {
                this.enqueue(e.getEvent(), e.getTime());
            }
        }
        this.resizeenabled = true;
    }

    @Override
    public void setSize(long size) {
        this.resize((int)size);
    }

    @Override
    public int size() {
        return this.qsize + this.infEntries.size();
    }
}

