/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.core.util.eventset.calendar;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jamesii.core.util.eventset.AbstractEventQueue;
import org.jamesii.core.util.eventset.Entry;
import org.jamesii.core.util.eventset.calendar.SortedList;

public class CalendarQueue<M>
extends AbstractEventQueue<M, Double> {
    private static final long serialVersionUID = 3174997486320091471L;
    private int botThreshold;
    private List<SortedList<Entry<M, Double>>> bucket = new ArrayList<SortedList<Entry<M, Double>>>();
    private double buckettop;
    private int firstsub;
    private Map<M, Double> infEntries = new HashMap<M, Double>();
    private int lastbucket;
    private double lastprio;
    private int nbuckets;
    private int qsize;
    private boolean resizeenabled = true;
    private int topThreshold;
    private double width;

    public CalendarQueue() {
        this(2);
    }

    public CalendarQueue(int initialsize) {
        this.localinit(0, initialsize, 1.0, 0.0);
    }

    @Override
    public Entry<M, Double> dequeue() {
        if (this.qsize == 0 && this.infEntries.size() > 0) {
            Iterator<Map.Entry<M, Double>> it = this.infEntries.entrySet().iterator();
            Map.Entry<M, Double> me = it.next();
            it.remove();
            return new Entry<M, Comparable>(me.getKey(), me.getValue());
        }
        if (this.lastbucket > this.nbuckets) {
            System.out.println("lastbucket is larger as the number of buckets, ups.");
        }
        if (this.lastbucket == this.nbuckets) {
            System.out.println("we are in the last bucket");
        }
        Entry<M, Double> e = null;
        if (this.qsize == 0) {
            return null;
        }
        int i = this.lastbucket;
        do {
            SortedList<Entry<M, Double>> buck;
            if ((buck = this.bucket.get(i)) != null && !buck.isEmpty() && buck.top().getTime() < this.buckettop) {
                e = buck.extractTop();
                this.lastbucket = i;
                this.lastprio = e.getTime();
                --this.qsize;
                if (this.qsize < this.botThreshold) {
                    this.resize(this.nbuckets / 2);
                }
                return e;
            }
            if (++i == this.nbuckets) {
                i = 0;
            }
            this.buckettop += this.width;
        } while (i != this.lastbucket);
        this.lastprio = Double.POSITIVE_INFINITY;
        for (i = 0; i < this.bucket.size(); ++i) {
            Entry<M, Double> ent;
            SortedList<Entry<M, Double>> ts = this.bucket.get(i);
            if (ts == null || ts.isEmpty() || (ent = ts.top()).getTime().compareTo(this.lastprio) != -1) continue;
            this.lastprio = ent.getTime();
            this.lastbucket = i;
            this.buckettop = this.width + this.lastprio;
        }
        return this.dequeue();
    }

    @Override
    public Double dequeue(M event) {
        if (this.infEntries.remove(event) == null) {
            for (SortedList<Entry<M, Double>> list : this.bucket) {
                if (list == null) continue;
                Iterator<Entry<M, Double>> eit = list.iterator();
                while (eit.hasNext()) {
                    Entry<M, Double> e = eit.next();
                    if (e.getEvent() != event) continue;
                    eit.remove();
                    --this.qsize;
                    return e.getTime();
                }
            }
        } else {
            return Double.POSITIVE_INFINITY;
        }
        return null;
    }

    protected void dequeue(M event, Double oldTime) {
        int i = (int)(oldTime / this.width);
        SortedList<Entry<M, Double>> buck = this.bucket.get(i %= this.nbuckets);
        if (buck != null) {
            Iterator<Entry<M, Double>> it = buck.iterator();
            while (it.hasNext()) {
                Entry<M, Double> e = it.next();
                if (e.getEvent() != event || e.getTime().compareTo(oldTime) != 0) continue;
                it.remove();
                --this.qsize;
                break;
            }
        }
    }

    @Override
    public ArrayList<M> dequeueAll() {
        if (this.qsize == 0) {
            ArrayList<M> res = new ArrayList<M>(this.infEntries.keySet());
            this.infEntries.clear();
            return res;
        }
        ArrayList<M> result = new ArrayList<M>();
        Entry<M, Double> firstOne = this.dequeue();
        double b_lastprio = this.lastprio;
        Entry<M, Double> e = firstOne;
        while (e != null && e.getTime().compareTo(firstOne.getTime()) == 0) {
            result.add(e.getEvent());
            e = this.dequeue();
        }
        this.lastprio = b_lastprio;
        if (e != null) {
            this.enqueue(e.getEvent(), e.getTime());
        }
        return result;
    }

    @Override
    public List<M> dequeueAll(Double time) {
        if (time == Double.POSITIVE_INFINITY) {
            ArrayList<M> res = new ArrayList<M>(this.infEntries.keySet());
            this.infEntries.clear();
            return res;
        }
        int i = (int)(time / this.width);
        SortedList<Entry<M, Double>> buck = this.bucket.get(i %= this.nbuckets);
        if (buck == null) {
            return null;
        }
        List<Entry<M, Double>> list = buck.getList();
        ArrayList<M> result = new ArrayList<M>();
        Iterator<Entry<M, Double>> it = list.iterator();
        while (it.hasNext()) {
            Entry<M, Double> e = it.next();
            if (e.getTime().compareTo(time) != 0) continue;
            result.add(e.getEvent());
            it.remove();
            --this.qsize;
        }
        return result;
    }

    @Override
    public Map<M, Object> dequeueAllHashed() {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        if (this.qsize == 0) {
            for (M k : this.infEntries.keySet()) {
                result.put(k, null);
            }
            this.infEntries.clear();
            return result;
        }
        List res = this.dequeueAll();
        for (int i = 0; i < ((ArrayList)res).size(); ++i) {
            result.put(((ArrayList)res).get(i), null);
        }
        return result;
    }

    @Override
    public void enqueue(M event, Double priority) {
        if (priority == Double.POSITIVE_INFINITY) {
            this.infEntries.put(event, priority);
            return;
        }
        int i = (int)(priority / this.width);
        SortedList<Entry<Object, Double>> buck = this.bucket.get(i %= this.nbuckets);
        if (buck == null) {
            buck = new SortedList();
            this.bucket.set(i, buck);
        }
        this.insert(new Entry<M, Double>(event, priority), buck);
        ++this.qsize;
        if (this.qsize > this.topThreshold) {
            this.resize(2 * this.nbuckets);
        }
    }

    private String getBucketString(SortedList<Entry<M, Double>> subList) {
        if (subList == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Entry<M, Double> m : subList.getList()) {
            stringBuilder.append(m.getTime());
            stringBuilder.append(" --- ");
            stringBuilder.append(m.getEvent());
            stringBuilder.append(" ### ");
        }
        return stringBuilder.toString();
    }

    protected Entry<M, Double> getLeast(ArrayList<Entry<M, Double>> list) {
        Double min = Double.POSITIVE_INFINITY;
        Entry<M, Double> result = null;
        for (Entry<M, Double> e : list) {
            if (min.compareTo(e.getTime()) <= 0) continue;
            min = e.getTime();
            result = e;
        }
        return result;
    }

    @Override
    public Double getMin() {
        Double t = Double.POSITIVE_INFINITY;
        boolean b = false;
        for (SortedList<Entry<M, Double>> al : this.bucket) {
            if (al == null || al.isEmpty()) continue;
            b = true;
            if (al.top().getTime().compareTo(t) >= 0) continue;
            t = al.top().getTime();
        }
        if (t.compareTo(Double.POSITIVE_INFINITY) == 0 && !b && this.infEntries.size() == 0) {
            return null;
        }
        return t;
    }

    public String getString() {
        String result = "";
        for (SortedList<Entry<M, Double>> subList : this.bucket) {
            result = result + this.getBucketString(subList) + "\n";
        }
        return result;
    }

    @Override
    public Double getTime(M event) {
        for (int i = 0; i < this.nbuckets; ++i) {
            SortedList<Entry<M, Double>> buck = this.bucket.get(i);
            if (buck == null) continue;
            for (Entry<M, Double> e : buck) {
                if (e.getEvent() != event) continue;
                return e.getTime();
            }
        }
        Double result = this.infEntries.get(event);
        return result;
    }

    public void initqueue() {
        this.localinit(0, 2, 1.0, 0.0);
        this.resizeenabled = true;
    }

    protected void insert(Entry<M, Double> e, SortedList<Entry<M, Double>> intoBucket) {
        intoBucket.add(e);
    }

    @Override
    public boolean isEmpty() {
        return this.qsize == 0;
    }

    public void localinit(int qbase, int nbuck, double bwidth, double startprio) {
        this.firstsub = qbase;
        this.width = bwidth;
        this.nbuckets = nbuck;
        if (this.bucket == null) {
            this.bucket = new ArrayList<SortedList<Entry<M, Double>>>(this.nbuckets);
        }
        this.qsize = 0;
        for (int i = 0; i < this.nbuckets; ++i) {
            this.bucket.add(i, null);
        }
        this.lastprio = startprio;
        int n = (int)(startprio / this.width);
        this.lastbucket = n % this.nbuckets;
        this.buckettop = (double)(n + 1) * this.width + 0.5 * this.width;
        this.botThreshold = this.nbuckets / 2 - 2;
        this.topThreshold = 2 * this.nbuckets;
    }

    double newwidth() {
        if (this.qsize < 2) {
            return 1.0;
        }
        int nsamples = this.qsize <= 5 ? this.qsize : 5 + this.qsize / 10;
        if (nsamples > 25) {
            nsamples = 25;
        }
        double average = 0.0;
        double b_lastprio = this.lastprio;
        int b_lastbucket = this.lastbucket;
        double b_buckettop = this.buckettop;
        this.resizeenabled = false;
        ArrayList<Entry<M, Double>> list = new ArrayList<Entry<M, Double>>();
        for (int i = 1; i < nsamples; ++i) {
            list.add(this.dequeue());
        }
        double[] prios = new double[nsamples - 1];
        for (int i = 1; i < nsamples; ++i) {
            Entry l = (Entry)list.get(i - 1);
            Double prio = (Double)l.getTime();
            this.enqueue(l.getEvent(), prio);
            prios[i - 1] = prio;
            average += prio.doubleValue();
        }
        if (Double.compare(average /= (double)nsamples, 0.0) == 0) {
            average = 1.0;
        }
        this.resizeenabled = true;
        this.lastprio = b_lastprio;
        this.lastbucket = b_lastbucket;
        this.buckettop = b_buckettop;
        return 3.0 * average;
    }

    public void print(PrintStream out) {
        int i = 0;
        for (SortedList<Entry<M, Double>> sortedList : this.bucket) {
            out.print(i++ + ": ");
            this.printBucket(sortedList, out);
            out.println();
        }
        for (Map.Entry entry : this.infEntries.entrySet()) {
            out.print(entry.getValue() + " --- " + entry.getKey() + " ### ");
        }
    }

    private void printBucket(SortedList<Entry<M, Double>> subList, PrintStream out) {
        out.print(this.getBucketString(subList));
    }

    public void printInfo() {
        System.out.println("CalendarQueue - debug info ");
        this.print(System.out);
        System.out.println("lastprio " + this.lastprio);
        System.out.println("lastbucket " + this.lastbucket);
        System.out.println("width " + this.width);
        System.out.println("nbuckets " + this.nbuckets);
        System.out.println("buckettop " + this.buckettop);
        System.out.println("qsize " + this.qsize);
        System.out.println("firstsub " + this.firstsub);
        System.out.println("top_treshold " + this.topThreshold);
        System.out.println("bot_treshold " + this.botThreshold);
    }

    @Override
    public void requeue(M event, Double newTime) {
        this.requeueIt(event, newTime);
    }

    @Override
    public void requeue(M event, Double oldTime, Double newTime) {
        if (this.infEntries.remove(event) != null) {
            this.enqueue(event, newTime);
            return;
        }
        if (oldTime != null) {
            this.dequeue(event, oldTime);
            this.enqueue(event, newTime);
        } else {
            this.requeueIt(event, newTime);
        }
    }

    protected void requeueIt(M event, Double newTime) {
        boolean found = this.infEntries.remove(event) != null;
        for (int i = 0; i < this.nbuckets && !found; ++i) {
            SortedList<Entry<M, Double>> buck = this.bucket.get(i);
            if (buck == null) continue;
            int r = -1;
            for (int j = 0; j < buck.size() && !found; ++j) {
                Entry<M, Double> e = buck.get(j);
                if (e.getEvent() != event) continue;
                found = true;
                r = j;
            }
            if (!found) continue;
            buck.remove(r);
            --this.qsize;
            break;
        }
        this.enqueue(event, newTime);
    }

    protected void resize(int newsize) {
        if (!this.resizeenabled) {
            return;
        }
        double bwidth = this.newwidth();
        List<SortedList<Entry<M, Double>>> oldbucket = this.bucket;
        this.bucket = null;
        this.localinit(0, newsize, bwidth, this.lastprio);
        this.resizeenabled = false;
        for (SortedList<Entry<M, Double>> list : oldbucket) {
            if (list == null) continue;
            for (Entry<M, Double> e : list.getList()) {
                this.enqueue(e.getEvent(), e.getTime());
            }
        }
        this.resizeenabled = true;
    }

    @Override
    public void setSize(long size) {
        this.resize((int)size);
    }

    @Override
    public int size() {
        return this.qsize + this.infEntries.size();
    }
}

