/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.core.util.eventset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jamesii.core.util.eventset.AbstractEventQueue;
import org.jamesii.core.util.eventset.Entry;

public class SimpleReBucketsEventQueue<E>
extends AbstractEventQueue<E, Double> {
    static final long serialVersionUID = -8663634212054878911L;
    private Map<Double, Map<E, Object>> bucket = new HashMap<Double, Map<E, Object>>();
    private Map<E, Double> events = new HashMap<E, Double>();

    @Override
    public Entry<E, Double> dequeue() {
        Double d = this.getMin();
        Map<E, Object> list = this.bucket.get(d);
        if (list == null) {
            return null;
        }
        Iterator<E> it = list.keySet().iterator();
        E e = it.next();
        it.remove();
        this.events.remove(e);
        if (!it.hasNext()) {
            this.bucket.remove(d);
        }
        return new Entry<E, Double>(e, d);
    }

    @Override
    public Double dequeue(E event) {
        Double time = this.events.remove(event);
        this.removeFromBucket(event, time);
        return time;
    }

    private void removeFromBucket(E event, Double time) {
        Map<E, Object> list = this.bucket.get(time);
        if (list != null) {
            list.remove(event);
            if (list.size() == 0) {
                this.bucket.remove(time);
            }
        }
    }

    @Override
    public List<E> dequeueAll() {
        return this.dequeueAll(this.getMin());
    }

    @Override
    public List<E> dequeueAll(Double time) {
        Map<E, Object> r = this.bucket.remove(time);
        if (r == null) {
            return new ArrayList();
        }
        for (E e : r.keySet()) {
            this.events.remove(e);
        }
        return new ArrayList<E>(r.keySet());
    }

    @Override
    public Map<E, Object> dequeueAllHashed() {
        return this.dequeueAllHashed(this.getMin());
    }

    public Map<E, Object> dequeueAllHashed(Double time) {
        Map<E, Object> r = this.bucket.remove(time);
        if (r == null) {
            return new HashMap();
        }
        for (E e : r.keySet()) {
            this.events.remove(e);
        }
        return r;
    }

    @Override
    public void enqueue(E event, Double time) {
        Map<E, Object> list;
        if (time < 0.0) {
            return;
        }
        Double oldTime = this.events.put(event, time);
        if (oldTime != null) {
            if (oldTime.equals(time)) {
                return;
            }
            this.removeFromBucket(event, oldTime);
        }
        if ((list = this.bucket.get(time)) == null) {
            list = new HashMap<E, Object>();
            this.bucket.put(time, list);
        }
        list.put(event, null);
    }

    @Override
    public Double getMin() {
        Double min = null;
        Iterator<Double> it = this.bucket.keySet().iterator();
        if (it.hasNext()) {
            min = it.next();
        }
        while (it.hasNext()) {
            Double d = it.next();
            if (!(min > d)) continue;
            min = d;
        }
        return min;
    }

    @Override
    public Double getTime(E event) {
        Double d = this.events.get(event);
        return d;
    }

    @Override
    public boolean isEmpty() {
        return this.bucket.isEmpty();
    }

    @Override
    public void requeue(E event, Double time) {
        this.enqueue(event, time);
    }

    @Override
    public void requeue(E event, Double oldTime, Double time) {
        this.enqueue(event, time);
    }

    @Override
    public int size() {
        return this.events.size();
    }
}

