/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.core.util.eventset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jamesii.core.util.eventset.AbstractEventQueue;
import org.jamesii.core.util.eventset.Entry;

public class SimpleBucketsEventQueue<E>
extends AbstractEventQueue<E, Double> {
    static final long serialVersionUID = 6815838204625838530L;
    private Map<Double, List<E>> events = new HashMap<Double, List<E>>();
    private int qsize;

    @Override
    public Entry<E, Double> dequeue() {
        Double min = this.getMin();
        List<E> list = this.events.get(min);
        if (list != null && list.size() != 0) {
            Entry<E, Double> r = new Entry<E, Double>(list.get(0), min);
            --this.qsize;
            if (list.size() == 1) {
                this.events.remove(min);
            } else {
                list.remove(0);
            }
            return r;
        }
        if (list != null) {
            this.events.remove(min);
        }
        return null;
    }

    @Override
    public Double dequeue(E event) {
        Iterator<Map.Entry<Double, List<E>>> it = this.events.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Double, List<E>> e = it.next();
            List<E> list = e.getValue();
            Iterator<E> it2 = list.iterator();
            while (it2.hasNext()) {
                if (it2.next() != event) continue;
                Double d = e.getKey();
                it2.remove();
                if (list.size() == 0) {
                    it.remove();
                }
                --this.qsize;
                return d;
            }
        }
        return null;
    }

    @Override
    public List<E> dequeueAll() {
        return this.dequeueAll(this.getMin());
    }

    @Override
    public List<E> dequeueAll(Double time) {
        List<E> result = this.events.get(time);
        if (result == null) {
            return new ArrayList();
        }
        this.events.remove(time);
        this.qsize -= result.size();
        return result;
    }

    @Override
    public Map<E, Object> dequeueAllHashed() {
        return this.dequeueAllHashed(this.getMin());
    }

    public Map<E, Object> dequeueAllHashed(Double time) {
        List<E> list = this.events.get(time);
        HashMap<E, Object> result = new HashMap<E, Object>();
        if (list == null) {
            return result;
        }
        for (E m : list) {
            result.put(m, null);
        }
        this.qsize -= list.size();
        this.events.remove(time);
        return result;
    }

    @Override
    public void enqueue(E event, Double time) {
        if (time < 0.0) {
            return;
        }
        List<E> list = this.events.get(time);
        if (list == null) {
            list = new ArrayList();
            this.events.put(time, list);
        }
        ++this.qsize;
        list.add(event);
    }

    @Override
    public Double getMin() {
        Double min = null;
        Iterator<Double> it = this.events.keySet().iterator();
        if (it.hasNext()) {
            min = it.next();
        }
        while (it.hasNext()) {
            Double d = it.next();
            if (Double.compare(min, d) <= 0) continue;
            min = d;
        }
        return min;
    }

    @Override
    public Double getTime(E event) {
        for (Double d : this.events.keySet()) {
            List<E> list = this.events.get(d);
            for (E m : list) {
                if (m != event) continue;
                return d;
            }
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    @Override
    public void requeue(E event, Double time) {
        this.dequeue((Object)event);
        this.enqueue(event, time);
    }

    @Override
    public void requeue(E event, Double oldTime, Double time) {
        this.dequeue((Object)event);
        this.enqueue(event, time);
    }

    @Override
    public int size() {
        return this.qsize;
    }
}

