/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.core.util.collection.list;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ReusableListIterator<E>
implements Iterator<E>,
Serializable {
    static final long serialVersionUID = -6144199426035407640L;
    private int current = -1;
    private List<E> elements;
    private int elementscount;
    private int next = -1;

    public ReusableListIterator(List<E> elements) {
        this.elements = elements;
        this.elementscount = elements != null ? elements.size() : -1;
        this.next = 0;
    }

    public void first() {
        this.current = 0;
        this.next = 1;
    }

    @Override
    public boolean hasNext() {
        return this.next < this.elementscount;
    }

    public void init() {
        this.current = -1;
        this.next = 0;
    }

    @Override
    public E next() {
        this.current = this.next++;
        if (this.current >= this.elementscount) {
            throw new NoSuchElementException("");
        }
        return this.elements.get(this.current);
    }

    @Override
    @Deprecated
    public void remove() {
        System.out.println("ERROR: Please use a private Iterator for deleting items");
    }
}

