/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.workflow;

import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import java.util.Collections;
import java.util.HashMap;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNodeMutation;
import org.jahia.modules.graphql.provider.dxm.node.NodeHelper;
import org.jahia.osgi.BundleUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.workflow.WorkflowService;

@GraphQLTypeExtension(value=GqlJcrNodeMutation.class)
public class WorkflowJCRNodeMutationExtensions {
    private GqlJcrNodeMutation nodeMutation;

    public WorkflowJCRNodeMutationExtensions(GqlJcrNodeMutation nodeMutation) {
        this.nodeMutation = nodeMutation;
    }

    @GraphQLField
    public boolean startWorkflow(@GraphQLName(value="definition") String workflowDefinitionId, @GraphQLName(value="language") String language) {
        WorkflowService service = (WorkflowService)BundleUtils.getOsgiService(WorkflowService.class, null);
        try {
            JCRNodeWrapper node = NodeHelper.getNodeInLanguage(this.nodeMutation.getNode().getNode(), language);
            service.startProcess(Collections.singletonList(node.getIdentifier()), node.getSession(), StringUtils.substringAfter((String)workflowDefinitionId, (String)":"), StringUtils.substringBefore((String)workflowDefinitionId, (String)":"), new HashMap(), null);
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
        return true;
    }
}

