/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.workflow;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import graphql.schema.DataFetchingEnvironment;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import java.util.List;
import java.util.Set;
import org.jahia.modules.graphql.provider.dxm.DXGraphQLProvider;
import org.jahia.modules.graphql.provider.dxm.util.BeanWrapper;
import org.jahia.modules.graphql.provider.dxm.workflow.GqlTask;
import org.jahia.modules.graphql.provider.dxm.workflow.GqlWorkflow;
import org.jahia.modules.graphql.provider.dxm.workflow.GqlWorkflowEvent;
import org.jahia.osgi.BundleUtils;
import org.jahia.services.workflow.HistoryWorkflow;
import org.jahia.services.workflow.Workflow;
import org.jahia.services.workflow.WorkflowListener;
import org.jahia.services.workflow.WorkflowService;
import org.jahia.services.workflow.WorkflowTask;
import org.reactivestreams.Publisher;

@GraphQLTypeExtension(value=DXGraphQLProvider.Subscription.class)
public class GqlWorkflowSubscriptionExtension {
    @GraphQLField
    @GraphQLDescription(value="Subscription on workflows")
    public static Publisher<GqlWorkflowEvent> workflowEvent(DataFetchingEnvironment environment) {
        return Flowable.create(obs -> {
            WorkflowService workflowService = (WorkflowService)BundleUtils.getOsgiService(WorkflowService.class, null);
            GqlWfListener wfListener = new GqlWfListener(workflowService, (FlowableEmitter<GqlWorkflowEvent>)obs, environment.getSelectionSet().get().keySet());
            workflowService.addWorkflowListener((WorkflowListener)wfListener);
            obs.setCancellable(() -> BeanWrapper.wrap(workflowService.getObservationManager()).get("listeners").unwrap(List.class).remove((Object)wfListener));
        }, (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }

    public static class GqlWfListener
    extends WorkflowListener {
        private final WorkflowService workflowService;
        private final FlowableEmitter<GqlWorkflowEvent> obs;
        private final Set<String> filters;

        public GqlWfListener(WorkflowService workflowService, FlowableEmitter<GqlWorkflowEvent> obs, Set<String> filters) {
            this.workflowService = workflowService;
            this.obs = obs;
            this.filters = filters;
            if (filters.contains("activeWorkflowTaskCountForUser")) {
                obs.onNext((Object)new GqlWorkflowEvent(workflowService));
            }
        }

        public void workflowStarted(Workflow workflow) {
            if (this.filters.contains("startedWorkflow")) {
                GqlWorkflowEvent t = new GqlWorkflowEvent(this.workflowService);
                t.setStartedWorkflow(new GqlWorkflow(workflow));
                this.obs.onNext((Object)t);
            }
        }

        public void workflowEnded(HistoryWorkflow workflow) {
            if (this.filters.contains("endedWorkflow")) {
                GqlWorkflowEvent t = new GqlWorkflowEvent(this.workflowService);
                this.obs.onNext((Object)t);
            }
        }

        public void newTaskCreated(WorkflowTask task) {
            if (this.filters.contains("createdTask") || this.filters.contains("activeWorkflowTaskCountForUser")) {
                GqlWorkflowEvent t = new GqlWorkflowEvent(this.workflowService);
                t.setCreatedTask(new GqlTask(task));
                this.obs.onNext((Object)t);
            }
        }

        public void taskEnded(WorkflowTask task) {
            if (this.filters.contains("endedTask") || this.filters.contains("activeWorkflowTaskCountForUser")) {
                GqlWorkflowEvent t = new GqlWorkflowEvent(this.workflowService);
                t.setEndedTask(new GqlTask(task));
                this.obs.onNext((Object)t);
            }
        }
    }
}

