/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.workflow;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.connection.GraphQLConnection;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import org.jahia.modules.graphql.provider.dxm.relay.DXPaginatedData;
import org.jahia.modules.graphql.provider.dxm.relay.DXPaginatedDataConnectionFetcher;
import org.jahia.modules.graphql.provider.dxm.relay.PaginationHelper;
import org.jahia.modules.graphql.provider.dxm.workflow.GqlTask;
import org.jahia.osgi.BundleUtils;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.workflow.WorkflowService;

@GraphQLName(value="WorkflowService")
@GraphQLDescription(value="Workflow service")
public class GqlWorkflowService {
    @GraphQLField
    @GraphQLDescription(value="Retrieves the number of active workflow tasks for the current user")
    public int getActiveWorkflowTaskCountForUser() {
        return ((WorkflowService)BundleUtils.getOsgiService(WorkflowService.class, null)).getTasksForUser(JCRSessionFactory.getInstance().getCurrentUser(), null).size();
    }

    @GraphQLField
    @GraphQLDescription(value="Retrieves the active workflow tasks for the current user")
    @GraphQLConnection(connectionFetcher=DXPaginatedDataConnectionFetcher.class)
    public DXPaginatedData<GqlTask> getActiveWorkflowTasksForUser(DataFetchingEnvironment environment) {
        List task = ((WorkflowService)BundleUtils.getOsgiService(WorkflowService.class, null)).getTasksForUser(JCRSessionFactory.getInstance().getCurrentUser(), null);
        PaginationHelper.Arguments arguments = PaginationHelper.parseArguments(environment);
        return PaginationHelper.paginate(task.stream().map(GqlTask::new), n -> PaginationHelper.encodeCursor(n.getId()), arguments);
    }
}

