/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.workflow;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import java.util.Calendar;
import org.apache.jackrabbit.util.ISO8601;
import org.jahia.services.workflow.Workflow;

@GraphQLName(value="Workflow")
@GraphQLDescription(value="Workflow process")
public class GqlWorkflow {
    private Workflow workflowProcess;

    public GqlWorkflow(Workflow workflowProcess) {
        this.workflowProcess = workflowProcess;
    }

    @GraphQLField
    @GraphQLName(value="startUser")
    @GraphQLDescription(value="Username who started the workflow")
    public String getStartUser() {
        return this.workflowProcess.getStartUser();
    }

    @GraphQLField
    @GraphQLDescription(value="Workflow creation time")
    public String getCreationTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.workflowProcess.getStartTime());
        return ISO8601.format((Calendar)calendar);
    }

    @GraphQLField
    @GraphQLDescription(value="Workflow due date")
    public String getDueDate() {
        if (this.workflowProcess.getDuedate() != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.workflowProcess.getDuedate());
            return ISO8601.format((Calendar)calendar);
        }
        return null;
    }
}

