/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.workflow;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import java.util.Calendar;
import org.apache.jackrabbit.util.ISO8601;
import org.jahia.modules.graphql.provider.dxm.user.GqlUser;
import org.jahia.modules.graphql.provider.dxm.workflow.GqlWorkflow;
import org.jahia.osgi.BundleUtils;
import org.jahia.services.workflow.WorkflowService;
import org.jahia.services.workflow.WorkflowTask;

@GraphQLName(value="Task")
@GraphQLDescription(value="Workflow task")
public class GqlTask {
    private WorkflowTask task;

    public GqlTask(WorkflowTask task) {
        this.task = task;
    }

    public WorkflowTask getTask() {
        return this.task;
    }

    @GraphQLField
    @GraphQLDescription(value="Task id")
    public String getId() {
        return this.task.getId();
    }

    @GraphQLField
    @GraphQLDescription(value="Task name")
    public String getName() {
        return this.task.getName();
    }

    @GraphQLField
    @GraphQLDescription(value="Task assignee")
    public GqlUser getAssignee() {
        if (this.task.getAssignee() != null) {
            return new GqlUser(this.task.getAssignee());
        }
        return null;
    }

    @GraphQLField
    @GraphQLDescription(value="Creation time")
    public String getCreationTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.task.getCreateTime());
        return ISO8601.format((Calendar)calendar);
    }

    @GraphQLField
    @GraphQLDescription(value="Due date")
    public String getDueDate() {
        if (this.task.getDueDate() != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.task.getDueDate());
            return ISO8601.format((Calendar)calendar);
        }
        return null;
    }

    @GraphQLField
    @GraphQLDescription(value="Parent workflow")
    public GqlWorkflow getWorkflow() {
        return new GqlWorkflow(((WorkflowService)BundleUtils.getOsgiService(WorkflowService.class, null)).getWorkflow(this.task.getProvider(), this.task.getProcessId(), null));
    }
}

