/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.user;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import org.jahia.modules.graphql.provider.dxm.user.GqlGroup;
import org.jahia.modules.graphql.provider.dxm.user.GqlPrincipal;
import org.jahia.modules.graphql.provider.dxm.user.GqlUser;
import org.jahia.modules.graphql.provider.dxm.user.PrincipalType;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;

@GraphQLDescription(value="Describes input using name and with principal type (user/group)")
public class PrincipalInput {
    private final PrincipalType principalType;
    private final String principalName;
    private final String principalKey;

    public PrincipalInput(@GraphQLName(value="type") @GraphQLNonNull PrincipalType principalType, @GraphQLName(value="name") @GraphQLNonNull String principalName) {
        this.principalType = principalType;
        this.principalName = principalName;
        this.principalKey = principalType.getPrincipalKey(principalName);
    }

    public PrincipalInput(String principalKey) {
        String[] principals = principalKey.split(":");
        this.principalType = PrincipalType.getByValue(principals[0]);
        this.principalName = principals[1];
        this.principalKey = principalKey;
    }

    public GqlPrincipal getPrincipal(String siteKey, JahiaUserManagerService userService, JahiaGroupManagerService groupService) {
        GqlPrincipal principal = null;
        if (this.principalType == PrincipalType.USER && userService != null) {
            JCRUserNode userNode = userService.lookupUser(this.principalName, siteKey);
            principal = userNode != null ? new GqlUser(userNode.getJahiaUser()) : null;
        } else if (this.principalType == PrincipalType.GROUP && groupService != null) {
            JCRGroupNode groupNode = groupService.lookupGroup(siteKey, this.principalName);
            if (groupNode == null) {
                groupNode = groupService.lookupGroup(null, this.principalName);
            }
            principal = groupNode != null ? new GqlGroup(groupNode.getJahiaGroup()) : null;
        }
        return principal;
    }

    @GraphQLField
    @GraphQLDescription(value="Get principal type (user/group)")
    public PrincipalType getType() {
        return this.principalType;
    }

    @GraphQLField
    @GraphQLDescription(value="Get principal name")
    public String getName() {
        return this.principalName;
    }

    public String getPrincipalKey() {
        return this.principalKey;
    }
}

