/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.user;

import graphql.annotations.annotationTypes.GraphQLDeprecate;
import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import org.jahia.data.viewhelper.principal.PrincipalViewHelper;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.SpecializedTypesHandler;
import org.jahia.modules.graphql.provider.dxm.osgi.annotations.GraphQLOsgiService;
import org.jahia.modules.graphql.provider.dxm.site.GqlJcrSite;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUser;

@GraphQLName(value="Current user")
@GraphQLDescription(value="GraphQL representation of a Jahia current user")
public class GqlCurrentUser {
    private final JahiaUser user;
    @Inject
    @GraphQLOsgiService
    private JahiaGroupManagerService groupManagerService;
    @Inject
    @GraphQLOsgiService
    private JCRSessionFactory jcrSessionFactory;

    public GqlCurrentUser(JahiaUser jahiaUser) {
        this.user = jahiaUser;
    }

    @GraphQLField
    @GraphQLNonNull
    @GraphQLDeprecate
    @GraphQLDescription(value="User name")
    public String getName() {
        return this.user.getName();
    }

    @GraphQLField
    @GraphQLNonNull
    @GraphQLDescription(value="Username of the user")
    public String getUsername() {
        return this.user.getName();
    }

    @GraphQLField
    @GraphQLDescription(value="First name of the user")
    public String getFirstname() {
        return this.user.getProperty("j:firstName");
    }

    @GraphQLField
    @GraphQLDescription(value="Last name of the user")
    public String getLastname() {
        return this.user.getProperty("j:lastName");
    }

    @GraphQLField
    @GraphQLDescription(value="Email of the user")
    public String getEmail() {
        return this.user.getProperty("j:email");
    }

    @GraphQLField
    @GraphQLDescription(value="User organization")
    public String getOrganization() {
        return this.user.getProperty("j:organization");
    }

    @GraphQLField
    @GraphQLDescription(value="Preferred language by the user")
    public String getLanguage() {
        return this.user.getProperty("preferredLanguage");
    }

    @GraphQLField
    @GraphQLDescription(value="Displays if user is locked")
    public boolean getLocked() {
        return Boolean.parseBoolean(this.user.getProperty("j:accountLocked"));
    }

    @GraphQLField
    @GraphQLDescription(value="Full display name")
    public String getDisplayName() {
        return PrincipalViewHelper.getFullName((Object)this.user);
    }

    @GraphQLField
    @GraphQLDescription(value="User property")
    public String getProperty(@GraphQLName(value="name") @GraphQLNonNull @GraphQLDescription(value="The name of the property") String name) {
        return this.user.getProperty(name);
    }

    @GraphQLField
    @GraphQLDescription(value="Site where the user is defined")
    public GqlJcrSite getSite() throws RepositoryException {
        return new GqlJcrSite((JCRNodeWrapper)this.jcrSessionFactory.getCurrentUserSession().getNode(this.user.getLocalPath()).getResolveSite());
    }

    @GraphQLField
    @GraphQLDescription(value="Is this principal member of the specified group")
    public boolean isMemberOf(@GraphQLName(value="group") @GraphQLDescription(value="Target group") String group, @GraphQLName(value="site") @GraphQLDescription(value="Site where the group is defined") String site) {
        JCRGroupNode groupNode = this.groupManagerService.lookupGroup(site, group);
        if (groupNode == null) {
            return false;
        }
        return groupNode.isMember(this.user.getLocalPath());
    }

    @GraphQLField
    @GraphQLDescription(value="Get the corresponding JCR node")
    public GqlJcrNode getNode() throws RepositoryException {
        return SpecializedTypesHandler.getNode(this.jcrSessionFactory.getCurrentUserSession().getNode(this.user.getLocalPath()));
    }
}

