/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.site;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import java.util.Locale;
import org.jahia.utils.LanguageCodeConverters;

@GraphQLName(value="JCRSiteLanguage")
@GraphQLDescription(value="Site language representation")
public class GqlSiteLanguage {
    private String language;
    private boolean activeInEdit;
    private boolean activeInLive;
    private boolean mandatory;

    public GqlSiteLanguage(String language, boolean activeInEdit, boolean activeInLive, boolean mandatory) {
        this.language = language;
        this.activeInEdit = activeInEdit;
        this.activeInLive = activeInLive;
        this.mandatory = mandatory;
    }

    @GraphQLField
    @GraphQLName(value="language")
    @GraphQLDescription(value="Language code")
    public String getLanguage() {
        return this.language;
    }

    @GraphQLField
    @GraphQLName(value="displayName")
    @GraphQLDescription(value="Display name")
    public String getDisplayName(@GraphQLName(value="language") @GraphQLDescription(value="Language") String displayLanguage) {
        Locale locale = LanguageCodeConverters.languageCodeToLocale((String)this.language);
        return displayLanguage != null ? locale.getDisplayName(Locale.forLanguageTag(displayLanguage)) : locale.getDisplayName(locale);
    }

    @GraphQLField
    @GraphQLDescription(value="Is this language active in edit")
    public boolean isActiveInEdit() {
        return this.activeInEdit;
    }

    @GraphQLField
    @GraphQLDescription(value="Is this language active in live")
    public boolean isActiveInLive() {
        return this.activeInLive;
    }

    @GraphQLField
    @GraphQLDescription(value="Is this language mandatory")
    public boolean isMandatory() {
        return this.mandatory;
    }
}

