/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.site;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import java.util.ArrayList;
import java.util.Collection;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNodeImpl;
import org.jahia.modules.graphql.provider.dxm.node.SpecializedType;
import org.jahia.modules.graphql.provider.dxm.node.SpecializedTypesHandler;
import org.jahia.modules.graphql.provider.dxm.site.GqlSiteLanguage;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;

@GraphQLName(value="JCRSite")
@GraphQLDescription(value="GraphQL representation of a site node")
@SpecializedType(value="jnt:virtualsite")
public class GqlJcrSite
extends GqlJcrNodeImpl
implements GqlJcrNode {
    private JCRSiteNode siteNode;

    public GqlJcrSite(JCRNodeWrapper node) throws RepositoryException {
        super(node);
        if (node instanceof JCRSiteNode) {
            this.siteNode = (JCRSiteNode)node;
        } else if (node.isNodeType("jnt:virtualsite")) {
            this.siteNode = node.getResolveSite();
        }
    }

    @GraphQLField
    @GraphQLName(value="sitekey")
    @GraphQLDescription(value="Site key")
    public String getSiteKey() {
        return this.siteNode.getSiteKey();
    }

    @GraphQLField
    @GraphQLName(value="serverName")
    @GraphQLDescription(value="Site server name")
    public String getServerName() {
        return this.siteNode.getServerName();
    }

    @GraphQLField
    @GraphQLName(value="description")
    @GraphQLDescription(value="Site description")
    public String getDescription() {
        return this.siteNode.getDescription();
    }

    @GraphQLField
    @GraphQLName(value="defaultLanguage")
    @GraphQLDescription(value="Site default language")
    public String getDefaultLanguage() {
        return this.siteNode.getDefaultLanguage();
    }

    @GraphQLField
    @GraphQLName(value="installedModules")
    @GraphQLDescription(value="Retrieves a collection of module IDs, which are installed on the site, the node belongs to")
    public Collection<String> getInstalledModules() {
        return this.siteNode.getInstalledModules();
    }

    @GraphQLField
    @GraphQLName(value="installedModulesWithAllDependencies")
    @GraphQLDescription(value="Retrieves a collection of module IDs, which are installed on the site, the node belongs to, as well as dependencies of those modules")
    public Collection<String> getInstalledModulesWithAllDependencies() {
        return this.siteNode.getInstalledModulesWithAllDependencies();
    }

    @GraphQLField
    @GraphQLName(value="languages")
    @GraphQLDescription(value="Site languages")
    public Collection<GqlSiteLanguage> getLanguages() {
        ArrayList<GqlSiteLanguage> result = new ArrayList<GqlSiteLanguage>();
        for (String s : this.siteNode.getLanguages()) {
            result.add(new GqlSiteLanguage(s, true, this.siteNode.getActiveLiveLanguages().contains(s), this.siteNode.getMandatoryLanguages().contains(s)));
        }
        for (String s : this.siteNode.getInactiveLanguages()) {
            result.add(new GqlSiteLanguage(s, false, false, this.siteNode.getMandatoryLanguages().contains(s)));
        }
        return result;
    }

    @GraphQLField
    @GraphQLName(value="homePage")
    @GraphQLDescription(value="Returns the node of the home page")
    public GqlJcrNode getHomePage() throws RepositoryException {
        return SpecializedTypesHandler.getNode(this.siteNode.getHome());
    }
}

