/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.service.wip;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import java.util.HashSet;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrMutationSupport;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNodeMutation;
import org.jahia.modules.graphql.provider.dxm.service.wip.GqlJcrWipInfo;
import org.jahia.osgi.BundleUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.wip.WIPInfo;
import org.jahia.services.wip.WIPService;

@GraphQLTypeExtension(value=GqlJcrNodeMutation.class)
@GraphQLName(value="WipInfoMutation")
public class GqlJcrWipInfoMutationExtension
extends GqlJcrMutationSupport {
    private GqlJcrNodeMutation node;
    private WIPService wipService = (WIPService)BundleUtils.getOsgiService(WIPService.class, null);

    public GqlJcrWipInfoMutationExtension(GqlJcrNodeMutation node) {
        this.node = node;
    }

    @GraphQLField
    @GraphQLDescription(value="Mutate wip information")
    @GraphQLName(value="mutateWipInfo")
    public boolean setWipInfo(@GraphQLName(value="wipInfo") @GraphQLNonNull @GraphQLDescription(value="Work in progress information to save") GqlJcrWipInfo wipInfo) {
        try {
            JCRNodeWrapper jcrNode = this.node.getNode().getNode();
            this.wipService.saveWipPropertiesIfNeeded(jcrNode, new WIPInfo(wipInfo.getStatus().name(), new HashSet<String>(wipInfo.getLanguages())));
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
        return true;
    }

    @GraphQLField
    @GraphQLDescription(value="Add wip information")
    @GraphQLName(value="createWipInfo")
    public boolean createWipInfo(@GraphQLName(value="wipInfo") @GraphQLNonNull @GraphQLDescription(value="Work in progress information to save") GqlJcrWipInfo wipInfo) {
        try {
            JCRNodeWrapper jcrNode = this.node.getNode().getNode();
            this.wipService.createWipPropertiesOnNewNode(jcrNode, new WIPInfo(wipInfo.getStatus().name(), new HashSet<String>(wipInfo.getLanguages())));
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
        return true;
    }
}

