/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.service.wip;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.service.wip.GqlJcrWipInfo;
import org.jahia.osgi.BundleUtils;
import org.jahia.services.wip.WIPInfo;
import org.jahia.services.wip.WIPService;

@GraphQLTypeExtension(value=GqlJcrNode.class)
@GraphQLDescription(value="Node extension for Work in progress")
public class GqlJcrWipInfoExtension {
    private GqlJcrNode node;
    private WIPService wipService;

    public GqlJcrWipInfoExtension(GqlJcrNode node) {
        this.node = node;
        this.wipService = (WIPService)BundleUtils.getOsgiService(WIPService.class, null);
    }

    @GraphQLField
    @GraphQLName(value="wipInfo")
    @GraphQLDescription(value="Read work in progress information for a given node")
    public GqlJcrWipInfo getWipInfo() {
        try {
            WIPInfo wipInfo = this.wipService.getWipInfo(this.node.getNode());
            return new GqlJcrWipInfo(GqlJcrWipInfo.WipStatus.valueOf(wipInfo.getStatus()), wipInfo.getLanguages());
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="defaultWipInfo")
    @GraphQLDescription(value="Read default Work in progress information. Set by \"wip.checkbox.checked\" system proprety")
    public GqlJcrWipInfo getDefaultWipInfo() {
        WIPInfo wipInfo = this.wipService.getDefaultWipInfo();
        return new GqlJcrWipInfo(GqlJcrWipInfo.WipStatus.valueOf(wipInfo.getStatus()), wipInfo.getLanguages());
    }
}

