/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.service.vanity;

import java.util.HashMap;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.validation.ConstraintViolationException;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.modules.graphql.provider.dxm.GqlConstraintViolationException;
import org.jahia.modules.graphql.provider.dxm.service.vanity.GqlJcrVanityUrlInput;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.seo.VanityUrl;
import org.jahia.services.seo.jcr.NonUniqueUrlMappingException;
import org.jahia.services.seo.jcr.VanityUrlService;

class VanityUrlMutationService {
    private JCRNodeWrapper targetNode;
    private VanityUrlService vanityUrlService;

    public VanityUrlMutationService(JCRNodeWrapper targetNode, VanityUrlService vanityUrlService) {
        this.targetNode = targetNode;
        this.vanityUrlService = vanityUrlService;
    }

    boolean update(VanityUrl vanityUrl, Boolean active, Boolean defaultMapping, String language, String url) {
        this.addOrUpdateVanity(vanityUrl, active, defaultMapping, language, url);
        return true;
    }

    boolean add(List<GqlJcrVanityUrlInput> vanityUrls) {
        HashMap<String, Object> errors = new HashMap<String, Object>();
        for (GqlJcrVanityUrlInput vanityUrl : vanityUrls) {
            try {
                VanityUrl v = new VanityUrl();
                v.setSite(this.targetNode.getResolveSite().getSiteKey());
                this.addOrUpdateVanity(v, vanityUrl.isActive(), vanityUrl.isDefaultMapping(), vanityUrl.getLanguage(), vanityUrl.getUrl());
            }
            catch (GqlConstraintViolationException e) {
                errors.put(vanityUrl.getUrl(), e.getExtensions());
            }
            catch (RepositoryException e) {
                throw new JahiaRuntimeException((Throwable)e);
            }
        }
        if (!errors.isEmpty()) {
            throw new GqlConstraintViolationException((Throwable)new Exception("unable to create vanity urls"), errors);
        }
        return true;
    }

    private void addOrUpdateVanity(VanityUrl vanityUrl, Boolean active, Boolean defaultMapping, String language, String url) throws GqlConstraintViolationException {
        try {
            if (active != null) {
                vanityUrl.setActive(active.booleanValue());
            }
            if (defaultMapping != null) {
                vanityUrl.setDefaultMapping(defaultMapping.booleanValue());
            }
            if (language != null) {
                vanityUrl.setLanguage(language);
            }
            if (url != null) {
                vanityUrl.setUrl(url);
            }
            vanityUrl.setFile(this.targetNode.isFile());
            this.vanityUrlService.saveVanityUrlMapping(this.targetNode, vanityUrl, false);
        }
        catch (ConstraintViolationException e) {
            HashMap<String, Object> extensions = new HashMap<String, Object>();
            extensions.put("type", ((Object)((Object)e)).getClass().getName());
            extensions.put("urlMapping", vanityUrl.getUrl());
            extensions.put("errorMessage", e.getMessage());
            if (e instanceof NonUniqueUrlMappingException) {
                NonUniqueUrlMappingException nonUniqueUrlMappingException = (NonUniqueUrlMappingException)e;
                extensions.put("existingNodePath", nonUniqueUrlMappingException.getExistingNodePath());
                extensions.put("workspace", nonUniqueUrlMappingException.getWorkspace());
                extensions.put("nodePath", nonUniqueUrlMappingException.getNodePath());
            }
            throw new GqlConstraintViolationException((Throwable)e, extensions);
        }
        catch (Exception e) {
            throw new JahiaRuntimeException((Throwable)e);
        }
    }
}

