/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.service.vanity;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.connection.GraphQLConnection;
import graphql.schema.DataFetchingEnvironment;
import java.util.Collection;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.relay.DXPaginatedData;
import org.jahia.modules.graphql.provider.dxm.relay.DXPaginatedDataConnectionFetcher;
import org.jahia.modules.graphql.provider.dxm.relay.PaginationHelper;
import org.jahia.modules.graphql.provider.dxm.service.vanity.GqlJcrVanityUrl;
import org.jahia.modules.graphql.provider.dxm.site.GqlJcrSite;
import org.jahia.osgi.BundleUtils;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.seo.jcr.VanityUrlService;
import pl.touk.throwing.ThrowingFunction;

@GraphQLDescription(value="Site Extension for vanity URL")
public class VanityUrlJCRSiteExtensions {
    private GqlJcrSite siteNode;

    public VanityUrlJCRSiteExtensions(GqlJcrSite node) {
        this.siteNode = node;
    }

    @GraphQLField
    @GraphQLName(value="findActiveVanityURL")
    @GraphQLDescription(value="return vanity urls")
    public GqlJcrVanityUrl findActiveVanityURL(@GraphQLNonNull @GraphQLName(value="url") String url) {
        List<GqlJcrVanityUrl> gqlJcrVanityUrls = this.getGqlJcrVanityUrls(url, true);
        if (gqlJcrVanityUrls.size() > 1) {
            throw new RuntimeException("more than one active vanity url matches " + url);
        }
        if (gqlJcrVanityUrls.isEmpty()) {
            throw new RuntimeException("no active vanity url matches " + url);
        }
        return gqlJcrVanityUrls.get(0);
    }

    @GraphQLField
    @GraphQLName(value="findVanityURLs")
    @GraphQLDescription(value="return vanity urls")
    public Collection<GqlJcrVanityUrl> findVanityURLs(@GraphQLNonNull @GraphQLName(value="url") String url) {
        return this.getGqlJcrVanityUrls(url, false);
    }

    private List<GqlJcrVanityUrl> getGqlJcrVanityUrls(String url, boolean activeOnly) {
        try {
            JCRSessionWrapper jcrSessionWrapper = this.siteNode.getNode().getSession();
            VanityUrlService vanityUrlvanityUrlService = (VanityUrlService)BundleUtils.getOsgiService(VanityUrlService.class, null);
            List urls = vanityUrlvanityUrlService.findExistingVanityUrls(url, this.siteNode.getSiteKey(), jcrSessionWrapper.getWorkspace().getName());
            return urls.stream().filter(vanityUrl -> !activeOnly || vanityUrl.isActive()).map(ThrowingFunction.unchecked(vanityUrl -> new GqlJcrVanityUrl(jcrSessionWrapper.getNode(vanityUrl.getPath())))).collect(Collectors.toList());
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="getAllVanityURLs")
    @GraphQLDescription(value="return vanity urls")
    @GraphQLConnection(connectionFetcher=DXPaginatedDataConnectionFetcher.class)
    public DXPaginatedData<GqlJcrVanityUrl> getAllVanityURLs(DataFetchingEnvironment environment) {
        try {
            PaginationHelper.Arguments arguments = PaginationHelper.parseArguments(environment);
            JCRSessionWrapper jcrSession = this.siteNode.getNode().getSession();
            String vanityQuery = "SELECT * FROM [jnt:vanityUrl] AS vanityURL WHERE ISDESCENDANTNODE('/sites/" + JCRContentUtils.sqlEncode((String)this.siteNode.getSiteKey()) + "')";
            QueryWrapper query = jcrSession.getWorkspace().getQueryManager().createQuery(vanityQuery, "JCR-SQL2");
            NodeIterator it = query.execute().getNodes();
            Stream<GqlJcrVanityUrl> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false).map(GqlJcrVanityUrl::new);
            return PaginationHelper.paginate(stream, v -> PaginationHelper.encodeCursor(v.getUuid()), arguments);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }
}

