/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.service.vanity;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.modules.graphql.provider.dxm.GqlConstraintViolationException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrMutationSupport;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNodeMutation;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrWrongInputException;
import org.jahia.modules.graphql.provider.dxm.service.vanity.GqlJcrVanityUrlInput;
import org.jahia.modules.graphql.provider.dxm.service.vanity.GqlVanityUrlMappingMutation;
import org.jahia.modules.graphql.provider.dxm.service.vanity.VanityUrlMutationService;
import org.jahia.osgi.BundleUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.seo.jcr.VanityUrlService;

@GraphQLTypeExtension(value=GqlJcrNodeMutation.class)
@GraphQLName(value="VanityUrlJCRNodeMutationExtensions")
public class VanityUrlJCRNodeMutationExtensions {
    private JCRNodeWrapper node;
    private VanityUrlService vanityUrlService = (VanityUrlService)BundleUtils.getOsgiService(VanityUrlService.class, null);
    private VanityUrlMutationService vanityUrlMutationService;

    public VanityUrlJCRNodeMutationExtensions(GqlJcrNodeMutation node) {
        this.node = node.getNode().getNode();
        this.vanityUrlMutationService = new VanityUrlMutationService(this.node, this.vanityUrlService);
    }

    @GraphQLField
    @GraphQLDescription(value="Add vanity URL")
    @GraphQLName(value="addVanityUrl")
    public Collection<GqlVanityUrlMappingMutation> addVanityUrl(@GraphQLName(value="vanityUrlInputList") @GraphQLNonNull @GraphQLDescription(value="The list of vanity url to create") List<GqlJcrVanityUrlInput> vanityUrlInputList) throws GqlConstraintViolationException {
        this.vanityUrlMutationService.add(vanityUrlInputList);
        try {
            JCRSessionWrapper session = this.node.getSession();
            return this.vanityUrlService.getVanityUrls(this.node, null, session).stream().filter(u -> vanityUrlInputList.stream().anyMatch(input -> u.getUrl().equals(input.getUrl()))).map(u -> new GqlVanityUrlMappingMutation(GqlJcrMutationSupport.getNodeFromPathOrId(session, u.getIdentifier()))).collect(Collectors.toList());
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException((Throwable)e);
        }
    }

    @GraphQLField
    @GraphQLDescription(value="Update a vanity URL")
    @GraphQLName(value="mutateVanityUrl")
    public Optional<GqlVanityUrlMappingMutation> mutateVanityUrl(@GraphQLName(value="url") @GraphQLNonNull @GraphQLDescription(value="The url to edit") String url) {
        try {
            JCRSessionWrapper session = this.node.getSession();
            return this.vanityUrlService.getVanityUrls(this.node, null, session).stream().filter(u -> url.equals(u.getUrl())).map(u -> new GqlVanityUrlMappingMutation(GqlJcrMutationSupport.getNodeFromPathOrId(session, u.getIdentifier()))).findFirst();
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException((Throwable)e);
        }
    }

    @GraphQLField
    @GraphQLDescription(value="Update vanity URLs")
    @GraphQLName(value="mutateVanityUrls")
    public Collection<GqlVanityUrlMappingMutation> mutateVanityUrls(@GraphQLName(value="languages") @GraphQLDescription(value="Filter by languages") Collection<String> languages) throws GqlJcrWrongInputException {
        try {
            JCRSessionWrapper session = this.node.getSession();
            return this.vanityUrlService.getVanityUrls(this.node, null, session).stream().filter(u -> languages == null || languages.contains(u.getLanguage())).map(u -> new GqlVanityUrlMappingMutation(GqlJcrMutationSupport.getNodeFromPathOrId(session, u.getIdentifier()))).collect(Collectors.toList());
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException((Throwable)e);
        }
    }
}

