/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.service.vanity;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrMutation;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrMutationSupport;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrWrongInputException;
import org.jahia.modules.graphql.provider.dxm.service.vanity.GqlVanityUrlMappingMutation;
import org.jahia.services.content.JCRNodeWrapper;

@GraphQLTypeExtension(value=GqlJcrMutation.class)
@GraphQLDescription(value="A mutation extension that adds a possibility to modify Vanity URLs")
public class VanityUrlJCRMutationExtensions
extends GqlJcrMutationSupport {
    private GqlJcrMutation mutation;

    public VanityUrlJCRMutationExtensions(GqlJcrMutation mutation) {
        this.mutation = mutation;
    }

    @GraphQLField
    @GraphQLDescription(value="Vanity URL Mutation")
    public Collection<GqlVanityUrlMappingMutation> mutateVanityUrls(@GraphQLName(value="pathsOrIds") @GraphQLNonNull @GraphQLDescription(value="Paths or UUIDs of vanity URL nodes to mutate") Collection<String> pathsOrIds) throws GqlJcrWrongInputException {
        return new HashSet<String>(pathsOrIds).stream().map(new Function<String, GqlVanityUrlMappingMutation>(){

            @Override
            public GqlVanityUrlMappingMutation apply(String pathOrId) {
                JCRNodeWrapper node = GqlJcrMutationSupport.getNodeFromPathOrId(VanityUrlJCRMutationExtensions.this.mutation.getSession(), pathOrId);
                return new GqlVanityUrlMappingMutation(node);
            }
        }).collect(Collectors.toList());
    }
}

